/**********************************************************************************************************************
 * Copyright (c) 2008, 2015 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors: Andreas Weber (Empolis Information Management GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.solr.httphandler;

import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.http.server.HttpExchange;
import org.eclipse.smila.http.server.util.URLCreator;

public class SolrAdminHandler extends AAdminHandler {

  @Override
  Any doGet(final HttpExchange exchange, final String requestUri) throws Exception {
    final String requestHost = getRequestHost(exchange);
    final String staticUriPart = getStaticUriPart(requestUri);
    final String rootContextPath = getRootContextPath();
    final String uri = rootContextPath + staticUriPart;

    final String urlCores = URLCreator.create(requestHost, uri, "cores").toString();
    final String urlCollections = URLCreator.create(requestHost, uri, "collections").toString();

    final AnyMap result = FACTORY.createAnyMap();

    final AnyMap usage = result.getMap("usage", true);
    usage.put("cores", urlCores);
    usage.put("collections", urlCollections);

    final Any status = _operationService.processAdminOperation("status", null);
    result.put("status", status);

    return result;
  }
}
