/**
 *
 */
package org.eclipse.smila.solr.params;

import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.SolrRequest.METHOD;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.util.AnyUtil;
import org.eclipse.smila.search.api.QueryConstants;
import org.eclipse.smila.solr.params.UpdateParams.Operation;

/**
 * @author pwissel
 *
 */
public class ParamsHelper {

  private ParamsHelper() {
    ; // prevent instance creation
  }

  public static Any setSubParam(final Record target, final String subMapName, final String key, final Object value) {
    return setSubParam(target.getMetadata(), subMapName, key, value);
  }

  public static Any setSubParam(final AnyMap target, final String subMapName, final String key, final Object value) {
    final Any val = convertToAny(key, value);
    return getSub(target, subMapName).put(key, val);
  }

  public static Any setSolrParam(final Record target, final String key, final Object value) {
    return setSolrParam(target.getMetadata(), key, value);
  }

  public static Any setSolrParam(final AnyMap target, final String key, final Object value) {
    final Any val = convertToAny(key, value);
    return getSolr(target).put(key, val);
  }

  public static Any setRootParam(final Record target, final String key, final Object value) {
    return setRootParam(target.getMetadata(), key, value);
  }

  public static Any setRootParam(final AnyMap target, final String key, final Object value) {
    final Any val = convertToAny(key, value);
    return getRoot(target).put(key, val);
  }

  private static AnyMap getSub(final AnyMap target, final String sub) {
    return getSolr(target).getMap(sub, true);
  }

  private static AnyMap getSolr(final AnyMap target) {
    return getRoot(target).getMap(SolrParams.SOLR_PARAMETER_ATTRIBUTE, true);
  }

  private static AnyMap getRoot(final AnyMap target) {
    if (target == null) {
      throw new IllegalArgumentException("Target must not be null.");
    }
    return target;
  }

  private static Any convertToAny(final String key, final Object value) {
    if (StringUtils.isBlank(key)) {
      throw new IllegalArgumentException("Key must not be blank.");
    }
    if (value == null) {
      throw new IllegalArgumentException("Value must not be null.");
    }
    return AnyUtil.objectToAny(value);
  }

  public static Any setUpdateAttachments(final Record target, final boolean attachments) {
    return setUpdateAttachments(target.getMetadata(), attachments);
  }

  public static Any setUpdateAttachments(final AnyMap target, final boolean attachments) {
    return setSubParam(target, UpdateParams.UPDATE, UpdateParams.ATTACHMENTS, attachments);
  }

  public static Any setUpdateCommitWithinMs(final Record target, final int commitWithinMs) {
    return setUpdateCommitWithinMs(target.getMetadata(), commitWithinMs);
  }

  public static Any setUpdateCommitWithinMs(final AnyMap target, final int commitWithinMs) {
    return setSubParam(target, UpdateParams.UPDATE, UpdateParams.COMMIT_WITHIN_MS, commitWithinMs);
  }

  public static Any setUpdateDocumentBoost(final Record target, final float documentBoost) {
    return setUpdateDocumentBoost(target.getMetadata(), documentBoost);
  }

  public static Any setUpdateDocumentBoost(final AnyMap target, final float documentBoost) {
    return setSubParam(target, UpdateParams.UPDATE, UpdateParams.DOCUMENT_BOOST, documentBoost);
  }

  public static Any setUpdateMapping(final Record target, final AnyMap mapping) {
    return setUpdateMapping(target.getMetadata(), mapping);
  }

  public static Any setUpdateMapping(final AnyMap target, final AnyMap mapping) {
    return setSubParam(target, UpdateParams.UPDATE, UpdateParams.MAPPING, mapping);
  }

  public static Any setUpdateOperation(final Record target, final Operation operation) {
    return setUpdateOperation(target.getMetadata(), operation);
  }

  public static Any setUpdateOperation(final AnyMap target, final Operation operation) {
    return setSubParam(target, UpdateParams.UPDATE, UpdateParams.OPERATION, operation.toString());
  }

  public static Any setUpdateDeleteQuery(final Record target, final String deleteQuery) {
    return setUpdateDeleteQuery(target.getMetadata(), deleteQuery);
  }

  public static Any setUpdateDeleteQuery(final AnyMap target, final String deleteQuery) {
    return setSubParam(target, UpdateParams.UPDATE, UpdateParams.DELETE_QUERY, deleteQuery);
  }

  public static Any setUpdateIndexName(final Record target, final String index) {
    return setUpdateIndexName(target.getMetadata(), index);
  }

  public static Any setUpdateIndexName(final AnyMap target, final String index) {
    return setRootParam(target, QueryConstants.INDEXNAME, index);
  }

  public static Any setSearchMethod(final Record target, final METHOD method) {
    return setSearchMethod(target.getMetadata(), method);
  }

  public static Any setSearchMethod(final AnyMap target, final METHOD method) {
    return setSubParam(target, SearchParams.SEARCH, SearchParams.HTTP_METHOD, method.toString());
  }

}
