/**
 *
 */
package org.eclipse.smila.solr.server;

import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.eclipse.smila.solr.SolrConfig;

/**
 * @author pwissel
 *
 */
public class HttpServers extends SolrServers {

  /**
   *
   */
  public HttpServers(final SolrConfig config) {
    super(config);
  }

  /*
   * (non-Javadoc)
   * 
   * @see org.eclipse.smila.solr.server.SolrServers#createServer(java.lang.String)
   */
  @Override
  protected SolrServer createServer(final String index) throws Exception {
    String baseUrl = getConfig().getHttpSolrServerBaseUrl();
    if (index != null) {
      baseUrl = addIndexName(baseUrl, index);
    }
    final HttpSolrServer server = new HttpSolrServer(baseUrl);
    return server;
  }

  @Override
  protected SolrServer createServer() throws Exception {
    return createServer(null);
  }

  private String addIndexName(String baseUrl, final String index) {
    baseUrl = StringUtils.endsWith(baseUrl, "/") ? baseUrl : baseUrl + "/";
    baseUrl += index;
    return baseUrl;
  }

}
