/**
 *
 */
package org.eclipse.smila.solr.service;

import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.eclipse.smila.solr.SolrConfig;
import org.eclipse.smila.solr.SolrConfig.Mode;
import org.eclipse.smila.solr.SolrServerService;
import org.eclipse.smila.solr.server.CloudServers;
import org.eclipse.smila.solr.server.EmbeddedServers;
import org.eclipse.smila.solr.server.HttpServers;
import org.eclipse.smila.solr.server.SolrServers;
import org.osgi.service.component.ComponentContext;

/**
 * @author pwissel
 *
 */
public class SolrServerServiceImpl implements SolrServerService {

  private final Log _log = LogFactory.getLog(getClass());

  private SolrConfig _config = new SolrConfig();

  private SolrServers _servers;

  /*
   * (non-Javadoc)
   *
   * @see org.eclipse.smila.solr.SolrServerService#getServer(java.lang.String)
   */
  @Override
  public SolrServer getServer(final String index) throws SolrServerException {
    return _servers.getServer(index);
  }

  @Override
  public SolrServer getServer() throws SolrServerException {
    return _servers.getServer();
  }

  @Override
  public SolrConfig getConfig() {
    return _config;
  }

  @Override
  public SolrConfig reloadConfig() {
    _servers.clearCache();
    return _config = new SolrConfig();
  }

  protected void activate(ComponentContext context) {
    if (_log.isInfoEnabled()) {
      _log.info("OSGI DS: Activate SolrServerService...");
    }
    final Mode mode = _config.getMode();
    if (_log.isDebugEnabled()) {
      _log.debug("Set mode: " + mode.toString());
    }
    switch (mode) {
      case CLOUD:
        _servers = new CloudServers(_config);
        break;
      case EMBEDDED:
        _servers = new EmbeddedServers(_config);
        break;
      case HTTP:
        _servers = new HttpServers(_config);
        break;
      default:
        throw new NotImplementedException(mode.toString());
    }
    if (_log.isDebugEnabled()) {
      _log.debug("SolrServerService activated successfully");
    }
  }

  protected void deactivate(ComponentContext context) {
    if (_log.isInfoEnabled()) {
      _log.info("OSGI DS: Deactivate SolrServerService...");
    }
    if (_servers != null) {
      _servers.shutdown();
    }
    if (_log.isDebugEnabled()) {
      _log.debug("SolrServerService deactivated successfully");
    }
  }

}
