/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Weber (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/

package org.eclipse.smila.taskmanager;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

/**
 *  
 */
public class TaskCounter {
  /**
   * name of the worker.
   */
  private final String _workerName;

  /**
   * numbers of tasks to do per jobs.
   */
  private final Map<String, Integer> _tasksTodoPerJobs;

  /**
   * number of tasks currently in progress.
   */
  private final int _tasksInProgress;

  /**
   * Conversion Constructor.
   * 
   * @param workerName
   *          the name of the worker
   * @param tasksTodo
   *          the numbers of todo tasks per jobs
   * @param tasksInProgress
   *          the number of tasks in progress
   */
  public TaskCounter(final String workerName, final Map<String, Integer> tasksTodoPerJobs, final int tasksInProgress) {
    super();
    _workerName = workerName;
    _tasksTodoPerJobs = tasksTodoPerJobs;
    _tasksInProgress = tasksInProgress;
  }

  /**
   * @return the name of the worker
   */
  public String getWorkerName() {
    return _workerName;
  }

  /**
   * gets the numbers of todo tasks per jobs.
   * 
   * @return the numbers of todo tasks per jobs
   */
  public Map<String, Integer> getTasksTodoPerJobs() {
    return _tasksTodoPerJobs;
  }

  /**
   * gets the number of todo tasks.
   * 
   * @return the number of todo tasks
   */
  public int getTasksTodo() {
    int count = 0;
    final Collection<Integer> values = _tasksTodoPerJobs.values();
    for (final Iterator<Integer> it = values.iterator(); it.hasNext();) {
      count += it.next();
    }
    return count;
  }

  /**
   * gets the number of tasks that are in progress.
   * 
   * @return the number of tasks in progress
   */
  public int getTasksInProgress() {
    return _tasksInProgress;
  }

  @Override
  public String toString() {
    return "TaskCounter [_workerName=" + _workerName + ", _tasksTodo=" + getTasksTodo() + ", _tasksInProgress="
      + getTasksInProgress() + "]";
  }
}
