/*********************************************************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
**********************************************************************************************************************/
package org.eclipse.smila.taskworker.test.worker;

import org.eclipse.smila.datamodel.Record;

import org.eclipse.smila.taskworker.TaskContext;
import org.eclipse.smila.taskworker.Worker;
import org.eclipse.smila.taskworker.input.Inputs;
import org.eclipse.smila.taskworker.input.RecordInput;
import org.eclipse.smila.taskworker.output.Outputs;
import org.eclipse.smila.taskworker.output.RecordOutput;

/**
 * Test worker for reading records and writing something to it.
 */
public class RecordToRecordWorker implements Worker {

  public static final String TEST_ATTRIBUTE = "recordToRecord";

  public static final String TEST_STRING = "RecordToRecordWorker was here :-)";

  public static final String NAME = "recordToRecordWorker";

  private static final String INPUT_SLOT_NAME = "inputRecords";

  private static final String OUTPUT_SLOT_NAME = "outputRecords";

  /**
   * Empty Constructor.
   */
  public RecordToRecordWorker() {
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void perform(TaskContext taskContext) {
    try {
      final Inputs inputs = taskContext.getInputs();
      final RecordInput recordInput = inputs.getAsRecordInput(INPUT_SLOT_NAME);
      final Outputs outputs = taskContext.getOutputs();
      final RecordOutput recordOutput = outputs.getAsRecordOutput(OUTPUT_SLOT_NAME);
      Record record = recordInput.getRecord();
      while (record != null) {
        try {
          record.getMetadata().put(TEST_ATTRIBUTE, TEST_STRING);
          recordOutput.writeRecord(record);
          record = recordInput.getRecord();
        } catch (Exception e) {
          record = null;
        }
      }
    } catch (Exception e) {
      e.printStackTrace();
    }
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getName() {
    return NAME;
  }
}
