/*********************************************************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 **********************************************************************************************************************/
package org.eclipse.smila.taskworker.test.worker;

import org.eclipse.smila.taskmanager.Task;
import org.eclipse.smila.taskworker.TaskContext;
import org.eclipse.smila.taskworker.Worker;

/**
 * Test worker that just waits some time while performing.
 * 
 * The time to wait can be either set by task parameter or directly via setter method.
 */
public class RunAlwaysWaitWorker implements Worker {

  public static final String NAME = "runAlwaysWaitWorker";

  public static final String PARAM_TIME_TO_WAIT = "timeToWait";

  public static final String PROPERTY_IS_CANCELED = "isCanceled";

  private static final long SLEEP_CYCLE_TIME = 100;

  private long _timeToWait;

  /**
   * default constructor used when getting OSGI service instance.
   */
  public RunAlwaysWaitWorker() {
  }

  /**
   * @param waitTime
   *          the time to wait in ms.
   */
  public RunAlwaysWaitWorker(final long waitTime) {
    _timeToWait = waitTime;
  }

  @Override
  public void perform(final TaskContext taskContext) {
    final Task task = taskContext.getTask();
    if (task != null && task.getParameters() != null) {
      final String ttw = task.getParameters().getStringValue(PARAM_TIME_TO_WAIT);
      if (ttw != null) {
        _timeToWait = Long.valueOf(ttw);
      }
    }
    try {
      final long r = _timeToWait % SLEEP_CYCLE_TIME;
      final long sleepLoops = _timeToWait / SLEEP_CYCLE_TIME; //
      for (int i = 0; i < sleepLoops; i++) {
        Thread.sleep(SLEEP_CYCLE_TIME);
        if (taskContext.isCanceled()) {
          task.getProperties().put(PROPERTY_IS_CANCELED, "true");
          return;
        }
      }
      Thread.sleep(r);
    } catch (final InterruptedException e) {
      ; // don't care...
      Thread.currentThread().interrupt();
    }
  }

  @Override
  public String getName() {
    return NAME;
  }

  /**
   * @param timeToWait
   *          the time to wait in perform()
   */
  public void setTimeToWait(final long timeToWait) {
    _timeToWait = timeToWait;
  }

}
