/*********************************************************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
**********************************************************************************************************************/
package org.eclipse.smila.taskworker.output;

/** Output modes. */
public enum OutputMode {
  /** Bulk has to be created for failsafe append. */
  APPENDABLE("appendable"),

  /** Output slot may not be connected with a (followup) bucket. */
  OPTIONAL("optional"),

  /** Worker may not create an output bulk when processing a task. */
  MAYBEEMPTY("maybeEmpty"),

  /** Worker may create more than one output bulks for this output slot when processing a task. */
  MULTIPLE("multiple");

  /** the display name of the Mode. */
  private String _name;

  /**
   * constructs an OutputMode.
   * 
   * @param name
   *          The name of the mode.
   */
  OutputMode(final String name) {
    _name = name;
  }

  /** {@inheritDoc} */
  @Override
  public String toString() {
    return _name;
  }
};
