package org.apache.poi.hwpf.usermodel;

import org.apache.poi.ddf.EscherBlipRecord;

public class Picture {
  private final int _startOffset;

  private final byte[] _content;

  public Picture(final EscherBlipRecord blipRecord) {
    _startOffset = 0;
    _content = new byte[0];
  }

  public Picture(final int dataBlockStartOffset, final byte[] dataStream, final boolean fillBytes) {
    _startOffset = dataBlockStartOffset;
    _content = dataStream;
  }

  public int getStartOffset() {
    return _startOffset;
  }

  public byte[] getContent() {
    return _content;
  }

  public String suggestFileExtension() {
    return "";
  }

  public String getMimeType() {
    return null;
  }

}
