/*******************************************************************************
 * Copyright (c) 2008, 2013 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved. 
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Weber (Empolis Information Management GmbH) - initial API and implementation
 *******************************************************************************/
package org.eclipse.smila.tika.test.manual;

import junit.framework.Test;
import junit.framework.TestSuite;

/**
 * Tests that will (only) run after manually adding _all_ tika dependencies, e.g. by removing standard tika.deps bundle
 * and adding downloaded tika dependencies to SMILA extensions.
 */
public final class AllManualTests {

  private AllManualTests() {
  }

  /**
   * Creates test suite.
   * 
   * @return Test suite.
   */
  public static Test suite() {

    final TestSuite suite = new TestSuite("Manual tests for org.eclipse.smila.tika");
    // $JUnit-BEGIN$    
    suite.addTestSuite(ManualTestTikaPipelet.class);
    suite.addTestSuite(ManualTestExtractPropertiesFromMediaFiles.class);
    suite.addTestSuite(ManualTestKeepHyphens.class);
    suite.addTestSuite(ManualTestKeepHyphensWithAttachments.class);
    suite.addTestSuite(ManualTestMaxLength.class);
    suite.addTestSuite(TestPageBreaks.class);
    suite.addTestSuite(TestMultiParts.class);

    // $JUnit-END$
    return suite;
  }
}
