/*********************************************************************************************************************
 * Copyright (c) 2008, 2015 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved.
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
**********************************************************************************************************************/
package org.eclipse.smila.tika.test.manual;

import org.eclipse.smila.tika.test.TestMaxLength;

/**
 * This test should run after removing standard tika.deps bundle and updating downloaded tika dependencies in SMILA
 * extensions.
 */
public class ManualTestMaxLength extends TestMaxLength {

  /** Test txt. */
  public void testTXT() throws Exception {
    final String fileName = "test.txt";
    String result = doTextExtraction(fileName, null, null);
    assertTrue(result.startsWith("SMILA"));
    result = doTextExtraction(fileName, 3, null);
    assertEquals("SMI", result);
  }

  /** Test utf-8 txt. */
  public void testUTF8TXT() throws Exception {
    final String fileName = "utf-8.txt";
    String result = doTextExtraction(fileName, null, null);
    assertTrue("was: " + result, result.startsWith("\u00ea SMILA"));
    result = doTextExtraction(fileName, 5, null);
    assertEquals("\u00ea SMI", result);
  }

}
