/**********************************************************************************************************************
 * Copyright (c) 2008, 2013 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved. This
 * program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Daniel Stucky (Empolis Information Management GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.tika.internal;

import java.io.Writer;

import org.apache.tika.sax.ToTextContentHandler;
import org.apache.tika.sax.WriteOutContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/**
 * Tika ContentHandler to add page breaks on DIV with class "page".
 */
public class PageBreakWriteOutContentHandler extends WriteOutContentHandler {

  public static final String PAGE_START_TAG = "<page>";

  public static final String PAGE_END_TAG = "</page>";

  private static final char[] PAGE_START_TAG_CHARS = PAGE_START_TAG.toCharArray();

  private static final char[] PAGE_END_TAG_CHARS = PAGE_END_TAG.toCharArray();

  /** {@inheritDoc} */
  public PageBreakWriteOutContentHandler(final ContentHandler handler, final int writeLimit) {
    super(handler, writeLimit);
  }

  /** {@inheritDoc} */
  public PageBreakWriteOutContentHandler(final Writer writer, final int writeLimit) {
    this(new ToTextContentHandler(writer), writeLimit);
  }

  @Override
  public void startElement(final String uri, final String localName, final String name, final Attributes atts)
    throws SAXException {
    try {
      if ("div".equals(name) && atts != null && "page".equals(atts.getValue("class"))) {
        super.characters(PAGE_START_TAG_CHARS, 0, PAGE_START_TAG_CHARS.length);
      }
      super.startElement(uri, localName, name, atts);
    } catch (final SAXException e) {
      handleException(e);
    }
  }

  @Override
  public void endElement(final String uri, final String localName, final String name) throws SAXException {
    try {
      super.endElement(uri, localName, name);
      if ("div".equals(name)) {
        super.characters(PAGE_END_TAG_CHARS, 0, PAGE_END_TAG_CHARS.length);
      }
    } catch (final SAXException e) {
      handleException(e);
    }
  }
}
