/*******************************************************************************
 * Copyright (c) 2008, 2013 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved. 
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Weber (Empolis Information Management GmbH) - initial API and implementation
 *******************************************************************************/
package org.eclipse.smila.tika.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TemporaryResources;

/**
 * 
 * @author stuc07
 * 
 */
public final class TemporaryResourcesHelper {

  private static final Log _log = LogFactory.getLog(TemporaryResourcesHelper.class);

  /**
   * Dispose TemporaryResources quietly without throwing exceptions.
   * 
   * @param tmp
   *          TemporaryResources
   */
  public static void disposeQuietly(final TemporaryResources tmp) {
    if (tmp != null) {
      try {
        tmp.dispose();
      } catch (final TikaException e) {
        _log.warn("Unable to dispose Tika TemporaryResources", e);
      }
    }
  }

  /** Private default Constructor to avoid instantiation. */
  private TemporaryResourcesHelper() {
  }
}
