/***********************************************************************************************************************
 * Copyright (c) 2008, 2013 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Empolis Information Management GmbH) - implementation
 **********************************************************************************************************************/
package org.eclipse.smila.utils.config;

/** service interface for configuration update watchers. */
public interface ConfigurationUpdateWatcher {

  public interface UpdateableService {
    void synchronizeConfiguration(String configName, boolean isDeleted);
  }

  /** register a service to be notified on configuration updates. */
  void registerService(UpdateableService service);

  /**
   * install a ZK watch on the root node to get notifications about changes.
   * 
   * @return true if watched was installed successfully
   */
  boolean startWatching();

  /**
   * stop watching: ZK watch on root node will not be reinstalled. Does not remove a currently installed watch, so it's
   * possible that remaining watches will still receive notifications after this call.
   */
  void stopWatching();

  /** start polling for updates. */
  void startPolling();

  /** start polling for updates with custom interval. */
  void startPolling(final int pollIntervalSeconds);

  /** stop polling for updates. */
  void stopPolling();

  /**
   * Initialize notification structure for configuration, call on initial load on service start. Does not trigger
   * notifications for other nodes, just ensure that the node is created.
   */
  void configLoadedOnStart(final String configName, final String timestamp);

  /** Send update notification, call on custom configuration creation or update. */
  void configUpdated(final String configName, final String timestamp);

  /** Send delete notification, call on custom configuration remove. */
  void configDeleted(final String configName);

  /** compare cluster versions of configurations with local versions and update local deployment. */
  void checkConfigVersions();

}
