/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Weber (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/

package org.eclipse.smila.workermanager.test;

import java.util.Collection;

import junit.framework.TestCase;

import org.eclipse.smila.taskmanager.Task;
import org.eclipse.smila.taskworker.DefaultTaskLogFactory;
import org.eclipse.smila.taskworker.TaskLogFactory;
import org.eclipse.smila.taskworker.internal.TaskContextImpl;
import org.eclipse.smila.taskworker.test.worker.WaitWorker;
import org.eclipse.smila.workermanager.internal.WorkerPool;
import org.eclipse.smila.workermanager.internal.WorkerRunner;

/** Test for WorkerPool class. */
public class TestWorkerPool extends TestCase {

  /** TaskLog factory. */
  private TaskLogFactory _taskLogFactory = new DefaultTaskLogFactory();

  /** test submitting tasks and getting results on completion. */
  public void test() throws Exception {
    // create some workers that just wait some time when performing
    final Task t1 = new Task("1", "waitWorker");
    final WorkerRunner worker0 =
      new WorkerRunner(new WaitWorker(0), new TaskContextImpl(t1, _taskLogFactory.getTaskLog(t1), null));
    final Task t2 = new Task("2", "waitWorker");
    final WorkerRunner worker1000 =
      new WorkerRunner(new WaitWorker(1000), new TaskContextImpl(t2, _taskLogFactory.getTaskLog(t2), null));
    final Task t3 = new Task("3", "waitWorker");
    final WorkerRunner worker1001 =
      new WorkerRunner(new WaitWorker(1001), new TaskContextImpl(t3, _taskLogFactory.getTaskLog(t3), null));
    final Task t4 = new Task("4", "waitWorker");
    final WorkerRunner worker1002 =
      new WorkerRunner(new WaitWorker(1002), new TaskContextImpl(t4, _taskLogFactory.getTaskLog(t4), null));
    final Task t5 = new Task("5", "waitWorker");
    final WorkerRunner worker3000 =
      new WorkerRunner(new WaitWorker(3000), new TaskContextImpl(t5, _taskLogFactory.getTaskLog(t5), null));

    final WorkerPool workerPool = new WorkerPool();
    workerPool.submit(worker0);
    workerPool.submit(worker1000);
    workerPool.submit(worker1001);
    workerPool.submit(worker1002);
    workerPool.submit(worker3000);

    Thread.sleep(100);
    Collection<WorkerRunner> completed = workerPool.getCompleted();
    assertEquals(1, completed.size());
    assertTrue(completed.contains(worker0));

    Thread.sleep(1500);
    completed = workerPool.getCompleted();
    assertEquals(3, completed.size());
    assertTrue(completed.contains(worker1000));
    assertTrue(completed.contains(worker1001));
    assertTrue(completed.contains(worker1002));

    Thread.sleep(2000);
    completed = workerPool.getCompleted();
    assertEquals(1, completed.size());
    assertTrue(completed.contains(worker3000));
  }
}
