/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.representation;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.restlet.data.MediaType;
import org.restlet.engine.io.BioUtils;
import org.restlet.engine.io.NioUtils;
import org.restlet.representation.Representation;

public abstract class StreamRepresentation
extends Representation {
    public StreamRepresentation(MediaType mediaType) {
        super(mediaType);
    }

    public ReadableByteChannel getChannel() throws IOException {
        return NioUtils.getChannel(this.getStream());
    }

    public Reader getReader() throws IOException {
        return BioUtils.getReader(this.getStream(), this.getCharacterSet());
    }

    public void write(WritableByteChannel writableChannel) throws IOException {
        this.write(NioUtils.getStream(writableChannel));
    }

    public void write(Writer writer) throws IOException {
        this.write(BioUtils.getStream(writer));
    }
}

