/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.common.definitions.ParameterDefinition;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.jobmanager.JobRun;
import org.eclipse.smila.jobmanager.JobRunDataProvider;
import org.eclipse.smila.jobmanager.JobRunEngine;
import org.eclipse.smila.jobmanager.JobRunInfo;
import org.eclipse.smila.jobmanager.JobState;
import org.eclipse.smila.jobmanager.definitions.Bucket;
import org.eclipse.smila.jobmanager.definitions.DefinitionPersistence;
import org.eclipse.smila.jobmanager.definitions.JobRunDefinitions;
import org.eclipse.smila.jobmanager.definitions.JobRunMode;
import org.eclipse.smila.jobmanager.definitions.WorkerDefinition;
import org.eclipse.smila.jobmanager.definitions.WorkflowAction;
import org.eclipse.smila.jobmanager.events.JobListener;
import org.eclipse.smila.jobmanager.events.PrepareToFinishEvent;
import org.eclipse.smila.jobmanager.exceptions.ConfigNotFoundException;
import org.eclipse.smila.jobmanager.exceptions.IllegalJobStateException;
import org.eclipse.smila.jobmanager.exceptions.JobDependencyException;
import org.eclipse.smila.jobmanager.exceptions.JobManagerException;
import org.eclipse.smila.jobmanager.exceptions.JobRunModeNotAllowedException;
import org.eclipse.smila.jobmanager.exceptions.PersistenceException;
import org.eclipse.smila.jobmanager.internal.JobRunImpl;
import org.eclipse.smila.jobmanager.internal.TaskParameterUtils;
import org.eclipse.smila.jobmanager.persistence.JobRunListener;
import org.eclipse.smila.jobmanager.persistence.PermanentStorage;
import org.eclipse.smila.jobmanager.persistence.RunStorage;
import org.eclipse.smila.jobmanager.persistence.RunStorageException;
import org.eclipse.smila.jobmanager.taskgenerator.TaskGenerationUtil;
import org.eclipse.smila.jobmanager.taskgenerator.TaskGenerator;
import org.eclipse.smila.jobmanager.taskgenerator.TaskGeneratorException;
import org.eclipse.smila.jobmanager.taskgenerator.TaskGeneratorProvider;
import org.eclipse.smila.objectstore.NoSuchStoreException;
import org.eclipse.smila.objectstore.ObjectStoreException;
import org.eclipse.smila.objectstore.ObjectStoreService;
import org.eclipse.smila.objectstore.util.ObjectStoreRetryUtil;
import org.eclipse.smila.taskmanager.Task;
import org.eclipse.smila.taskmanager.TaskManager;
import org.eclipse.smila.taskmanager.TaskmanagerException;

public class JobRunEngineImpl
implements JobRunEngine,
JobRunListener {
    private static final int JOB_RUN_ID_SUFFIX_MAX = 1000;
    private static final Random RANDOM = new Random(System.nanoTime());
    private final Log _log = LogFactory.getLog(this.getClass());
    private RunStorage _runStorage;
    private PermanentStorage _permStorage;
    private DefinitionPersistence _defPersistence;
    private TaskManager _taskManager;
    private TaskGeneratorProvider _taskGeneratorProvider;
    private ObjectStoreService _objectStore;
    private JobRunDataProvider _dataProvider;
    private final Map<String, JobRun> _jobRuns = new HashMap<String, JobRun>();
    private final CopyOnWriteArrayList<JobListener> _jobListeners = new CopyOnWriteArrayList();

    @Override
    public String startJob(String jobName) throws JobManagerException {
        return this.startJob(jobName, null);
    }

    @Override
    public String startJob(String jobName, JobRunMode requestedJobRunMode) throws JobManagerException {
        this._log.info((Object)("start called for job '" + jobName + "', jobRunMode '" + (Object)((Object)requestedJobRunMode) + "'"));
        String jobId = null;
        JobState currentState = null;
        try {
            if (!this._defPersistence.hasJob(jobName)) {
                throw new IllegalArgumentException("No definition for job '" + jobName + "' exists.");
            }
            currentState = this._runStorage.getJobState(jobName);
            if (currentState != null) {
                throw new IllegalStateException("Job '" + jobName + "' is in state '" + (Object)((Object)currentState) + "'.");
            }
            JobRunDefinitions jobRunDefs = this._dataProvider.getJobRunDefinitions(jobName);
            JobRunMode jobRunMode = this.checkJobRunMode(requestedJobRunMode, jobRunDefs);
            this.checkJobDependenciesForStarting(jobRunDefs);
            jobId = this.createJobId();
            this._runStorage.startJobRun(jobName, jobId, jobRunMode, jobRunDefs);
            this._runStorage.registerJobRunListener(this, jobName);
            JobRun jobRun = this.ensureJobRun(jobName, jobId);
            this.checkBuckets(jobRun);
            this.addJobTriggers(jobRun);
            if (this._runStorage.setJobState(jobName, jobId, JobState.PREPARING, JobState.RUNNING)) {
                if (JobRunMode.RUNONCE == jobRunMode) {
                    this.executeRunOnceJob(jobRun);
                }
                this._log.info((Object)("started job run '" + jobId + "' for job '" + jobName + "'"));
                return jobId;
            }
            throw new JobManagerException("Error while starting job '" + jobName + "' with jobId '" + jobId + "'. ");
        }
        catch (Exception e) {
            throw this.newJobStartFailure(jobName, jobId, currentState, e);
        }
    }

    private JobManagerException newJobStartFailure(String jobName, String jobId, JobState currentState, Exception e) throws JobManagerException {
        String messagePrefix = "Could not start job '" + jobName + "': ";
        if (jobId != null && (currentState = this._runStorage.getJobState(jobName)) == null) {
            AnyMap jobData = null;
            try {
                jobData = this._dataProvider.getJobRunData(jobName, jobId, false);
            }
            catch (ConfigNotFoundException configNotFoundException) {}
            if (jobData != null && jobData.getStringValue("state") != null) {
                currentState = JobState.valueOf(jobData.getStringValue("state"));
            }
        }
        if (currentState == JobState.CANCELED || currentState == JobState.CANCELLING) {
            return new JobManagerException(String.valueOf(messagePrefix) + "Job run was canceled while starting.", e);
        }
        this.cleanupFailedJobRun(jobName, jobId);
        return new JobManagerException(String.valueOf(messagePrefix) + e.getMessage(), e);
    }

    private JobRunMode checkJobRunMode(JobRunMode requestedRunMode, JobRunDefinitions jobRunDefs) throws JobManagerException {
        if (requestedRunMode == null) {
            JobRunMode defaultRunMode = jobRunDefs.getJobDefinition().getDefaultJobRunMode();
            if (defaultRunMode == null) {
                defaultRunMode = jobRunDefs.getWorkflowDefinition().getDefaultJobRunMode();
            }
            if (defaultRunMode == null) {
                return JobRunMode.STANDARD;
            }
            return defaultRunMode;
        }
        List<JobRunMode> allowedRunModes = jobRunDefs.getJobDefinition().getJobRunModes();
        if (allowedRunModes == null) {
            allowedRunModes = jobRunDefs.getWorkflowDefinition().getJobRunModes();
        }
        if (allowedRunModes == null || allowedRunModes.contains((Object)requestedRunMode)) {
            return requestedRunMode;
        }
        throw new JobRunModeNotAllowedException("Job '" + jobRunDefs.getJobDefinition().getName() + "' or its workflow does not allow run mode '" + (Object)((Object)requestedRunMode) + "'.");
    }

    @Override
    public void finishJob(String jobName, String jobRunId) throws JobManagerException {
        JobState state;
        if (this._log.isInfoEnabled()) {
            this._log.info((Object)("finish called for job '" + jobName + "', run '" + jobRunId + "'"));
        }
        if ((state = this._runStorage.getJobState(jobName, jobRunId)) == JobState.RUNNING) {
            this.checkNoDependentJobIsRunning(jobName, jobRunId);
            for (JobListener jobListener : this._jobListeners) {
                try {
                    jobListener.processJobEvent(new PrepareToFinishEvent(jobName, jobRunId));
                }
                catch (Throwable t) {
                    this._log.error((Object)("JobListener failed to process PrepareToFinishEvent for job '" + jobName + "', rob run id '" + jobRunId + "'."), t);
                }
            }
            if (this._runStorage.finishJobRun(jobName, jobRunId)) {
                this.removeJobTriggers(this.ensureJobRun(jobName, jobRunId));
                this.checkAndHandleJobRunCompleted(jobName, jobRunId);
            }
        } else {
            if (state == null) {
                throw this.newExceptionNoCurrentJobRun(jobName, jobRunId);
            }
            throw new IllegalJobStateException("Job run '" + jobRunId + "' of job '" + jobName + "' couldn't be finished, because it's in state '" + (Object)((Object)state) + "'.");
        }
    }

    @Override
    public void cancelJob(String jobName, String jobRunId) throws JobManagerException {
        int tries = 0;
        boolean success = false;
        JobState state = null;
        do {
            state = this._runStorage.getJobState(jobName, jobRunId);
            this.checkJobRunStateForJobRunCancelling(jobName, jobRunId, state);
        } while (!(success = this._runStorage.setJobState(jobName, jobRunId, state, JobState.CANCELLING)) && ++tries <= 3);
        try {
            this.removeTasksQuietly(jobName, jobRunId);
            List<String> workflowRunIds = this._runStorage.getWorkflowRuns(jobName, jobRunId);
            for (String workflowRun : workflowRunIds) {
                this.deleteTransientBulks(jobName, jobRunId, workflowRun);
            }
            this._runStorage.cancelJobRun(jobName, jobRunId, workflowRunIds);
            this.completeJobRun(jobName, jobRunId, JobState.CANCELED);
        }
        catch (Exception e) {
            throw new JobManagerException("Error while canceling job run '" + jobRunId + "' of job '" + jobName + "'", e);
        }
    }

    private void checkJobRunStateForJobRunCancelling(String jobName, String jobRunId, JobState state) throws JobManagerException {
        if (state == null) {
            throw this.newExceptionNoCurrentJobRun(jobName, jobRunId);
        }
        if (state == JobState.CANCELLING || state == JobState.CANCELED) {
            throw new IllegalJobStateException("Job run '" + jobRunId + "' of job '" + jobName + "' couldn't be canceled, because someone else canceled it before.");
        }
        if (state == JobState.SUCCEEDED || state == JobState.FAILED || state == JobState.CLEANINGUP) {
            throw new IllegalJobStateException("Job run '" + jobRunId + "' of job '" + jobName + "' couldn't be canceled, because it's in state '" + (Object)((Object)state) + "'.");
        }
    }

    private void checkJobRunStateForWorkflowRunCancelling(String jobName, String jobRunId, String workflowRunId, JobState state) throws JobManagerException {
        if (state == null) {
            throw this.newExceptionNoCurrentJobRun(jobName, jobRunId);
        }
        if (state != JobState.RUNNING && state != JobState.FINISHING) {
            throw new IllegalJobStateException("Workflow run '" + workflowRunId + "' for job run '" + jobRunId + "' of job '" + jobName + "' is only allowed in job run state RUNNING or FINISHING, was: " + (Object)((Object)state));
        }
    }

    @Override
    public JobRun ensureJobRun(String jobName, String jobRunId) throws JobManagerException {
        JobRun jobRun = this._jobRuns.get(jobName);
        if (jobRun == null || !jobRunId.equals(jobRun.getJobRunId())) {
            try {
                jobRun = new JobRunImpl(jobRunId, jobName, this._runStorage, this._defPersistence);
            }
            catch (Exception e) {
                throw new JobManagerException("Error during creation of job run: ", e);
            }
            this._jobRuns.put(jobName, jobRun);
        }
        return jobRun;
    }

    @Override
    public void deleteTransientBulks(String jobName, String jobRunId, String workflowRunId) {
        try {
            Collection<String> transientBulks = this._runStorage.getTransientBulks(jobName, jobRunId, workflowRunId);
            for (String transientBulkId : transientBulks) {
                int indexOfSlash = transientBulkId.indexOf(47);
                if (indexOfSlash <= 0 || transientBulkId.length() <= indexOfSlash) {
                    this._log.warn((Object)("Stored transient bulk id '" + transientBulkId + "' is invalid, skipping"));
                    continue;
                }
                String storeName = transientBulkId.substring(0, indexOfSlash);
                String objectId = transientBulkId.substring(indexOfSlash + 1);
                try {
                    this.removeStoreObjectQuietly(storeName, objectId);
                    if (!this._log.isDebugEnabled()) continue;
                    this._log.debug((Object)("Deleted transient bulk '" + objectId + "' from store'" + storeName + "'."));
                }
                catch (Exception e) {
                    this._log.warn((Object)("Error while deleting transient bulk object '" + objectId + "' in store '" + storeName + "'. It could not be deleted."), (Throwable)e);
                }
            }
        }
        catch (JobManagerException ex) {
            this._log.warn((Object)"Failed to retrieve stored transient bulk Ids, obsolete data remains in stores possibly.", (Throwable)((Object)ex));
        }
    }

    @Override
    public void checkAndHandleJobRunCompleted(String jobName, String jobRunId) throws JobManagerException {
        boolean ok;
        boolean hasActiveWorkflowRuns = this._runStorage.checkAndCleanupActiveWorkflowRuns(jobName, jobRunId);
        if (!hasActiveWorkflowRuns && this._runStorage.getJobState(jobName) == JobState.FINISHING) {
            ok = this._runStorage.setJobState(jobName, jobRunId, JobState.FINISHING, JobState.COMPLETING);
            if (ok) {
                if (this.jobRunWouldSucceed(jobName)) {
                    try {
                        this.addCompletionTaksForJobRun(jobName, jobRunId);
                    }
                    catch (TaskGeneratorException e) {
                        this._log.warn((Object)"Cannot start completing workflow run due to task generator error: ", (Throwable)((Object)e));
                        this.completeJobRun(jobName, jobRunId, JobState.FAILED);
                        throw new JobManagerException("Could not start completing workflow run. Job run failed.", (Throwable)((Object)e), false);
                    }
                } else if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)"Cannot run completing workflow run, since job run failed.");
                }
            } else {
                this._log.warn((Object)("Couldn't change job state from " + (Object)((Object)JobState.FINISHING) + " to " + (Object)((Object)JobState.COMPLETING) + " for job run '" + jobRunId + "' of job '" + jobName + "'"));
            }
        }
        if (!(hasActiveWorkflowRuns = this._runStorage.checkAndCleanupActiveWorkflowRuns(jobName, jobRunId)) && this._runStorage.getJobState(jobName) == JobState.COMPLETING) {
            ok = this._runStorage.setJobState(jobName, jobRunId, JobState.COMPLETING, JobState.CLEANINGUP);
            if (ok) {
                boolean succeeded = this.jobRunWouldSucceed(jobName);
                if (succeeded) {
                    this.completeJobRun(jobName, jobRunId, JobState.SUCCEEDED);
                } else {
                    this.completeJobRun(jobName, jobRunId, JobState.FAILED);
                    this.removeTasksQuietly(jobName, jobRunId);
                }
            } else {
                this._log.warn((Object)("Couldn't change job state from " + (Object)((Object)JobState.COMPLETING) + " to " + (Object)((Object)JobState.CLEANINGUP) + " for job run '" + jobRunId + "' of job '" + jobName + "'"));
            }
        }
    }

    private void addCompletionTaksForJobRun(String jobName, String jobRunId) throws JobManagerException {
        block8: {
            JobRun jobRun = this.ensureJobRun(jobName, jobRunId);
            JobRunDefinitions jobDefinitions = this._dataProvider.getJobRunDefinitions(jobRun.getJobName());
            Collection<WorkflowAction> actionsRequestingCompletion = this.getActionsWithWorkersRequestingCompletion(jobDefinitions);
            if (!actionsRequestingCompletion.isEmpty()) {
                String workflowRunId = this._runStorage.startCompletionWorkflowRun(jobRun.getJobName(), jobRun.getJobRunId());
                try {
                    Collection<Task> completionTasks = this.getCompletionTasksForJob(jobRun, workflowRunId, actionsRequestingCompletion);
                    if (!completionTasks.isEmpty()) {
                        this._runStorage.startTasks(jobRun.getJobName(), jobRun.getJobRunId(), workflowRunId, completionTasks);
                    }
                    if (completionTasks.isEmpty()) {
                        this._runStorage.successfulWorkflowRun(jobRun.getJobName(), jobRun.getJobRunId(), workflowRunId);
                        this._runStorage.deleteWorkflowRun(jobRun.getJobName(), jobRun.getJobRunId(), workflowRunId);
                    }
                    try {
                        this._taskManager.addTasks(completionTasks);
                        break block8;
                    }
                    catch (TaskmanagerException e) {
                        throw new JobManagerException("Could not add completion tasks for job '" + jobName + "', run id '" + jobRunId + "'.", e);
                    }
                }
                catch (JobManagerException e) {
                    this._runStorage.failedWorkflowRun(jobRun.getJobName(), jobRun.getJobRunId(), workflowRunId);
                    this._runStorage.deleteWorkflowRun(jobRun.getJobName(), jobRun.getJobRunId(), workflowRunId);
                    throw e;
                }
            }
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("No completing tasks requested for job '" + jobName + "'."));
            }
        }
    }

    private Collection<Task> getCompletionTasksForJob(JobRun jobRun, String workflowRunId, Collection<WorkflowAction> actions) throws JobManagerException {
        ArrayList<Task> completionTasks = new ArrayList<Task>();
        for (WorkflowAction action : actions) {
            WorkerDefinition workerDef = this._defPersistence.getWorker(action.getWorker());
            TaskGenerator taskGenerator = this._taskGeneratorProvider.getTaskGenerator(workerDef);
            List<Task> completionTasksForWorker = taskGenerator.createCompletionTasks(jobRun.getInputBucketsForAction(action), jobRun.getOutputBucketsForAction(action), jobRun.getParameters(action), action.getWorker());
            TaskGenerationUtil.setAdditionalTaskProperties(completionTasksForWorker, jobRun, workflowRunId, workerDef, action.getPosition());
            completionTasks.addAll(completionTasksForWorker);
        }
        return completionTasks;
    }

    Collection<WorkflowAction> getActionsWithWorkersRequestingCompletion(JobRunDefinitions jobRunDefinitions) {
        ArrayList<WorkflowAction> actionsRequestingCompletionTasks = new ArrayList<WorkflowAction>();
        ArrayList<WorkflowAction> workflowActions = new ArrayList<WorkflowAction>();
        workflowActions.add(jobRunDefinitions.getWorkflowDefinition().getStartAction());
        if (jobRunDefinitions.getWorkflowDefinition().getActions() != null) {
            workflowActions.addAll(jobRunDefinitions.getWorkflowDefinition().getActions());
        }
        for (WorkflowAction action : workflowActions) {
            WorkerDefinition workerDef = this._defPersistence.getWorker(action.getWorker());
            if (!workerDef.getModes().contains((Object)WorkerDefinition.Mode.REQUESTSCOMPLETION)) continue;
            actionsRequestingCompletionTasks.add(action);
        }
        return actionsRequestingCompletionTasks;
    }

    @Override
    public void deleteJobRunData(String jobName, String jobId) throws JobManagerException {
        String currentJobRunId = this._runStorage.getJobRunId(jobName);
        if (jobId.equals(currentJobRunId)) {
            throw new JobManagerException("Job run data of active job run cannot be deleted.");
        }
        this._permStorage.deleteJobRunData(jobName, jobId);
    }

    @Override
    public Map<String, String> getJobRunsUsingStore(String storeName) {
        HashMap<String, String> jobRuns = new HashMap<String, String>();
        try {
            Collection<String> currentJobs = this._runStorage.getCurrentJobs();
            for (String jobName : currentJobs) {
                String jobRunId = this._runStorage.getJobRunId(jobName);
                JobRun jobRun = null;
                if (jobRunId == null) continue;
                try {
                    jobRun = this.ensureJobRun(jobName, jobRunId);
                }
                catch (JobManagerException jobManagerException) {}
                if (jobRun == null) continue;
                Collection<Bucket> buckets = jobRun.getBuckets();
                for (Bucket bucket : buckets) {
                    if (!bucket.getStoreName().equals(storeName)) continue;
                    jobRuns.put(jobName, jobRunId);
                }
            }
        }
        catch (RunStorageException runStorageException) {}
        return jobRuns;
    }

    @Override
    public void notifiyAboutJobRunCompletion(String jobName) {
        JobRun jobRun = this._jobRuns.get(jobName);
        if (jobRun != null) {
            String jobRunId = jobRun.getJobRunId();
            try {
                if (this._permStorage.containsJobRun(jobName, jobRunId)) {
                    this._jobRuns.remove(jobName);
                }
            }
            catch (PersistenceException e) {
                this._log.warn((Object)"Error while checking if job run is finished.", (Throwable)((Object)e));
            }
        }
    }

    @Override
    public String startWorkflowRun(JobRun jobRun) throws JobManagerException {
        String workflowRunId = this._runStorage.startWorkflowRun(jobRun.getJobName(), jobRun.getJobRunId());
        for (WorkflowAction barrier : jobRun.getBarrierActions()) {
            this._runStorage.setupBarrier(jobRun.getJobName(), workflowRunId, barrier.getPosition());
        }
        return workflowRunId;
    }

    @Override
    public void cancelWorkflowRun(String jobName, String jobRunId, String workflowRunId) throws JobManagerException {
        if (this._log.isInfoEnabled()) {
            this._log.info((Object)("Cancel called for workflow run '" + workflowRunId + "' in job '" + jobName + "', job run '" + jobRunId + "'"));
        }
        JobState state = this._runStorage.getJobState(jobName, jobRunId);
        this.checkJobRunStateForWorkflowRunCancelling(jobName, jobRunId, workflowRunId, state);
        try {
            AnyMap taskFilter = DataFactory.DEFAULT.createAnyMap();
            taskFilter.put("jobName", jobName);
            taskFilter.put("jobRunId", jobRunId);
            taskFilter.put("workflowRunId", workflowRunId);
            this._taskManager.removeTasks(taskFilter);
            this.deleteTransientBulks(jobName, jobRunId, workflowRunId);
            this._runStorage.cancelWorkflowRun(jobName, jobRunId, workflowRunId);
            this.checkAndHandleJobRunCompleted(jobName, jobRunId);
        }
        catch (TaskmanagerException e) {
            throw new JobManagerException("Error while canceling workflow run " + workflowRunId + " in job run '" + jobRunId + "' of job '" + jobName + "': TaskManager couldn't remove canceled tasks", e);
        }
        catch (Exception e) {
            throw new JobManagerException("Error while canceling workflow run " + workflowRunId + " in job run '" + jobRunId + "' of job '" + jobName + "'", e);
        }
    }

    private synchronized String createJobId() {
        Date date = new Date();
        return String.format("%1$tY%1$tm%1$td-%1$tH%1$tM%1$tS%1$tL%2$03d", date, RANDOM.nextInt(1000));
    }

    private void checkBuckets(JobRun jobRun) throws ObjectStoreException {
        for (Bucket bucket : jobRun.getBuckets()) {
            if (bucket.isTransient()) {
                ObjectStoreRetryUtil.retryEnsureStore((ObjectStoreService)this._objectStore, (String)bucket.getStoreName());
                continue;
            }
            if (ObjectStoreRetryUtil.retryExistsStore((ObjectStoreService)this._objectStore, (String)bucket.getStoreName())) continue;
            throw new NoSuchStoreException("Store '" + bucket.getStoreName() + "' of persistent bucket '" + bucket.getBucketId() + "' does not exist.");
        }
    }

    private void addJobTriggers(JobRun jobRun) throws RunStorageException {
        String jobName = jobRun.getJobName();
        for (Bucket triggerBucket : jobRun.getTriggerBuckets()) {
            this._runStorage.addJobTrigger(triggerBucket.getBucketId(), jobName);
        }
    }

    private void executeRunOnceJob(JobRun jobRun) throws JobManagerException, TaskmanagerException {
        String workflowRunId = this.startWorkflowRun(jobRun);
        List<Task> followUpTasks = this.getInitialRunOnceTasks(jobRun, workflowRunId);
        if (!followUpTasks.isEmpty()) {
            this._runStorage.startTasks(jobRun.getJobName(), jobRun.getJobRunId(), workflowRunId, followUpTasks);
        }
        this.finishJob(jobRun.getJobName(), jobRun.getJobRunId());
        if (followUpTasks.isEmpty()) {
            this._runStorage.successfulWorkflowRun(jobRun.getJobName(), jobRun.getJobRunId(), workflowRunId);
            this._runStorage.deleteWorkflowRun(jobRun.getJobName(), jobRun.getJobRunId(), workflowRunId);
            this.checkAndHandleJobRunCompleted(jobRun.getJobName(), jobRun.getJobRunId());
        }
        this.storeTasksForBarriers(jobRun, workflowRunId, followUpTasks);
        this._taskManager.addTasks(followUpTasks);
    }

    private void storeTasksForBarriers(JobRun jobRun, String workflowRunId, List<Task> followUpTasks) throws RunStorageException {
        WorkflowAction action;
        Collection<WorkflowAction> barriers;
        if (jobRun.hasBarriers() && (barriers = jobRun.getBarriersForAction(action = jobRun.getStartAction())) != null) {
            for (WorkflowAction barrier : barriers) {
                for (Task task : followUpTasks) {
                    this._runStorage.addTaskForBarrier(jobRun.getJobName(), workflowRunId, barrier.getPosition(), task.getTaskId());
                }
            }
        }
    }

    private List<Task> getInitialRunOnceTasks(JobRun jobRun, String workflowRunId) throws TaskGeneratorException {
        WorkflowAction startAction = jobRun.getStartAction();
        WorkerDefinition workerDef = this._defPersistence.getWorker(startAction.getWorker());
        TaskGenerator taskGenerator = this._taskGeneratorProvider.getTaskGenerator(workerDef);
        AnyMap parameters = jobRun.getParameters(startAction);
        Map<String, Bucket> inputSlotNameToBucket = jobRun.getInputBucketsForAction(startAction);
        Map<String, Bucket> outputSlotNameToBucketMap = jobRun.getOutputBucketsForAction(startAction);
        List<Task> tasks = taskGenerator.createRunOnceTasks(inputSlotNameToBucket, outputSlotNameToBucketMap, parameters, startAction.getWorker());
        TaskGenerationUtil.setAdditionalTaskProperties(tasks, jobRun, workflowRunId, workerDef, startAction.getPosition());
        return tasks;
    }

    private void cleanupFailedJobRun(String jobName, String jobRunId) {
        if (jobRunId != null) {
            try {
                String currentJobRunId;
                if (this._jobRuns.containsKey(jobName) && jobRunId.equals(currentJobRunId = this._runStorage.getJobRunId(jobName))) {
                    this.removeJobTriggers(this._jobRuns.get(jobName));
                }
                this.completeJobRun(jobName, jobRunId, JobState.FAILED);
            }
            catch (Exception ex) {
                this._log.warn((Object)("Error while cleaning up failed job '" + jobName + "' with run '" + jobRunId + "' after prepare."), (Throwable)ex);
            }
        }
    }

    private void removeJobTriggers(JobRun jobRun) throws RunStorageException {
        String jobName = jobRun.getJobName();
        for (Bucket triggerBucket : jobRun.getTriggerBuckets()) {
            try {
                this._runStorage.removeJobTrigger(triggerBucket.getBucketId(), jobName);
            }
            catch (Exception ex) {
                this._log.info((Object)("Could not remove job '" + jobName + "' from trigger bucket '" + triggerBucket.getBucketId() + "'. This is not critical."), (Throwable)ex);
            }
        }
    }

    private JobManagerException newExceptionNoCurrentJobRun(String jobName, String jobRunId) throws PersistenceException {
        if (!this._defPersistence.hasJob(jobName)) {
            return new ConfigNotFoundException("Couldn't find job definition '" + jobName + "'.");
        }
        if (!this._permStorage.containsJobRun(jobName, jobRunId)) {
            return new ConfigNotFoundException("Couldn't find job run '" + jobRunId + "' for job '" + jobName + "'.");
        }
        return new IllegalJobStateException("Requested job run '" + jobRunId + "' of job '" + jobName + "' was already closed, can be found in job run history.", true);
    }

    private void completeJobRun(String jobName, String jobRunId, JobState finalState) throws JobManagerException {
        if (this._log.isInfoEnabled()) {
            this._log.info((Object)("Cleaning up job run '" + jobRunId + "' for job '" + jobName + "' with final state " + (Object)((Object)finalState)));
        }
        AnyMap jobRunData = DataFactory.DEFAULT.createAnyMap();
        String currentJobRunId = this._runStorage.getJobRunId(jobName);
        if (jobRunId.equals(currentJobRunId)) {
            jobRunData.putAll((Map)this._runStorage.getJobRunData(jobName, true));
        }
        jobRunData.put("state", finalState.name());
        jobRunData.put("endTime", this._runStorage.getCurrentTimestamp());
        this._permStorage.storeJobRun(jobName, jobRunId, this.sortedJobRunData(jobRunData));
        if (jobRunId.equals(currentJobRunId)) {
            this._runStorage.deleteJobRun(jobName, jobRunId);
            this._jobRuns.remove(jobName);
        }
    }

    private boolean jobRunWouldSucceed(String jobName) throws RunStorageException {
        AnyMap jobRunData = this._runStorage.getJobRunData(jobName, false);
        AnyMap workflowRunData = jobRunData.getMap("workflowRuns");
        int startedWorkflowRuns = Integer.parseInt(workflowRunData.getStringValue("startedWorkflowRunCount"));
        int successfulWorkflowRuns = Integer.parseInt(workflowRunData.getStringValue("successfulWorkflowRunCount"));
        return startedWorkflowRuns <= 0 || successfulWorkflowRuns != 0;
    }

    private void removeStoreObjectQuietly(String storeName, String objectId) {
        try {
            this._objectStore.removeObject(storeName, objectId);
        }
        catch (Exception ex) {
            this._log.warn((Object)("Error removing obsolete input object '" + objectId + "'"), (Throwable)ex);
        }
    }

    private AnyMap sortedJobRunData(AnyMap jobRunData) {
        TreeMap<String, Any> simpleValues = new TreeMap<String, Any>();
        AnyMap complexValues = jobRunData.getFactory().createAnyMap();
        for (Map.Entry entry : jobRunData.entrySet()) {
            String key = (String)entry.getKey();
            Any value = (Any)entry.getValue();
            if (value.isValue()) {
                simpleValues.put(key, value);
                continue;
            }
            complexValues.put(key, value);
        }
        AnyMap sortedData = jobRunData.getFactory().createAnyMap();
        sortedData.putAll(simpleValues);
        sortedData.putAll((Map)complexValues);
        return sortedData;
    }

    private void checkJobDependenciesForStarting(JobRunDefinitions jobRunDefs) throws JobManagerException {
        Map<String, WorkerDefinition> referredJobs = this.getReferredJobs(jobRunDefs);
        this.checkReferredJobsAreRunning(jobRunDefs, referredJobs);
    }

    private Map<String, WorkerDefinition> getReferredJobs(JobRunDefinitions jobRunDefs) {
        HashMap<String, WorkerDefinition> referredJobs = new HashMap<String, WorkerDefinition>();
        ArrayList<WorkflowAction> workflowActions = new ArrayList<WorkflowAction>();
        if (jobRunDefs.getWorkflowDefinition().getStartAction() != null) {
            workflowActions.add(jobRunDefs.getWorkflowDefinition().getStartAction());
        }
        if (jobRunDefs.getWorkflowDefinition().getActions() != null) {
            workflowActions.addAll(jobRunDefs.getWorkflowDefinition().getActions());
        }
        for (WorkflowAction workflowAction : workflowActions) {
            WorkerDefinition workerDefinition = this._defPersistence.getWorker(workflowAction.getWorker());
            List<ParameterDefinition> jobNameParameters = workerDefinition.getParametersByRange("jobName");
            if (jobNameParameters.isEmpty()) continue;
            AnyMap jobParameters = jobRunDefs.getJobDefinition().getParameters();
            AnyMap workflowParameters = jobRunDefs.getWorkflowDefinition().getParameters();
            AnyMap evaluatedParameters = TaskParameterUtils.mergeAndEvaluateParameters(jobParameters, workflowParameters, workflowAction.getParameters(), workflowAction.getWorker());
            for (ParameterDefinition jobNameParameter : jobNameParameters) {
                String jobNameValue = evaluatedParameters.getStringValue(jobNameParameter.getName());
                if (jobNameValue == null) continue;
                referredJobs.put(jobNameValue, workerDefinition);
            }
        }
        return referredJobs;
    }

    private void checkReferredJobsAreRunning(JobRunDefinitions jobRunDefs, Map<String, WorkerDefinition> referredJobs) throws JobManagerException {
        ArrayList<String> referredJobsThatAreNotRunning = new ArrayList<String>();
        for (Map.Entry<String, WorkerDefinition> entry : referredJobs.entrySet()) {
            String jobName = entry.getKey();
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Checking if job '" + jobName + "' is running (job '" + jobRunDefs.getJobDefinition().getName() + "', worker '" + entry.getValue().getName() + "'."));
            }
            try {
                JobState state = this._runStorage.getJobState(jobName);
                if (state == JobState.RUNNING || jobName.equals(jobRunDefs.getJobDefinition().getName())) continue;
                referredJobsThatAreNotRunning.add(jobName);
            }
            catch (RunStorageException e) {
                throw new JobManagerException("Error during start of job '" + jobRunDefs.getJobDefinition().getName() + "'. Cannot check if referred job '" + jobName + "' is running.", (Throwable)((Object)e));
            }
        }
        if (referredJobsThatAreNotRunning.size() == 1) {
            throw new JobDependencyException("Error during start of job '" + jobRunDefs.getJobDefinition().getName() + "' because the referred job " + this.getJobsString(referredJobsThatAreNotRunning) + " is not running.");
        }
        if (referredJobsThatAreNotRunning.size() > 1) {
            throw new JobDependencyException("Error during start of job '" + jobRunDefs.getJobDefinition().getName() + "' because the referred jobs " + this.getJobsString(referredJobsThatAreNotRunning) + " are not running.");
        }
    }

    private void checkNoDependentJobIsRunning(String jobNameOfJobToBeFinished, String jobRunIdOfJobToBeFinished) throws JobManagerException {
        ArrayList<String> dependentJobs = new ArrayList<String>();
        for (String jobName : this._defPersistence.getJobs()) {
            JobRunInfo jobRunInfo = this._dataProvider.getJobRunInfo(jobName);
            if (jobRunInfo == null || jobName.equals(jobNameOfJobToBeFinished)) continue;
            switch (jobRunInfo.getState()) {
                case PREPARING: 
                case RUNNING: 
                case FINISHING: 
                case COMPLETING: 
                case CLEANINGUP: {
                    if (!this.checkIfJobIsDependent(jobName, jobNameOfJobToBeFinished)) break;
                    dependentJobs.add(jobName);
                    break;
                }
            }
        }
        if (dependentJobs.size() == 1) {
            throw new JobDependencyException("Cannot finish job '" + jobNameOfJobToBeFinished + "' because dependent job " + this.getJobsString(dependentJobs) + " is still running.");
        }
        if (dependentJobs.size() > 1) {
            throw new JobDependencyException("Cannot finish job '" + jobNameOfJobToBeFinished + "' because dependent jobs " + this.getJobsString(dependentJobs) + " are still running.");
        }
    }

    private String getJobsString(Collection<String> dependentJobs) {
        StringBuilder jobsStringbuilder = new StringBuilder();
        Iterator<String> dependentJobNamesIter = dependentJobs.iterator();
        while (dependentJobNamesIter.hasNext()) {
            String dependentJob = dependentJobNamesIter.next();
            jobsStringbuilder.append('\'').append(dependentJob).append('\'');
            if (!dependentJobNamesIter.hasNext()) continue;
            jobsStringbuilder.append(", ");
        }
        return jobsStringbuilder.toString();
    }

    private boolean checkIfJobIsDependent(String jobName, String jobNameOfJobToBeFinished) throws JobManagerException {
        JobRunDefinitions jobRunDefs = this._dataProvider.getJobRunDefinitions(jobName);
        Map<String, WorkerDefinition> referredJobs = this.getReferredJobs(jobRunDefs);
        return referredJobs.containsKey(jobNameOfJobToBeFinished);
    }

    private void removeTasksQuietly(String jobName, String jobRunId) {
        AnyMap taskFilter = DataFactory.DEFAULT.createAnyMap();
        taskFilter.put("jobName", jobName);
        taskFilter.put("jobRunId", jobRunId);
        try {
            this._taskManager.removeTasks(taskFilter);
        }
        catch (TaskmanagerException taskmanagerException) {
            this._log.warn((Object)("Couldn't remove taskmanager tasks for job run " + jobRunId + " of job " + jobName));
        }
    }

    public void addJobListener(JobListener listener) {
        this._jobListeners.add(listener);
    }

    public void removeJobListener(JobListener listener) {
        if (this._jobListeners.contains(listener)) {
            this._jobListeners.remove(listener);
        }
    }

    public void setPermanentStorage(PermanentStorage permStorage) {
        this._permStorage = permStorage;
    }

    public void unsetPermanentStorage(PermanentStorage permStorage) {
        if (this._permStorage == permStorage) {
            this._permStorage = null;
        }
    }

    public void setRunStorage(RunStorage runStorage) {
        this._runStorage = runStorage;
    }

    public void unsetRunStorage(RunStorage runStorage) {
        if (this._runStorage == runStorage) {
            this._runStorage = null;
        }
    }

    public void setObjectStoreService(ObjectStoreService objectStore) {
        this._objectStore = objectStore;
    }

    public void unsetObjectStoreService(ObjectStoreService objectStore) {
        if (this._objectStore == objectStore) {
            this._objectStore = null;
        }
    }

    public void setTaskGeneratorProvider(TaskGeneratorProvider taskGeneratorProvider) {
        this._taskGeneratorProvider = taskGeneratorProvider;
    }

    public void unsetTaskGeneratorProvider(TaskGeneratorProvider taskGeneratorProvider) {
        if (this._taskGeneratorProvider == taskGeneratorProvider) {
            this._taskGeneratorProvider = null;
        }
    }

    public void setTaskManager(TaskManager taskManager) {
        this._taskManager = taskManager;
    }

    public void unsetTaskManager(TaskManager taskManager) {
        if (this._taskManager == taskManager) {
            this._taskManager = null;
        }
    }

    public void setDefinitionPersistence(DefinitionPersistence defPersistence) {
        this._defPersistence = defPersistence;
    }

    public void unsetDefinitionPersistence(DefinitionPersistence defPersistence) {
        if (this._defPersistence == defPersistence) {
            this._defPersistence = null;
        }
    }

    public void setJobRunDataProvider(JobRunDataProvider dataProvider) {
        this._dataProvider = dataProvider;
    }

    public void unsetJobRunDataProvider(JobRunDataProvider dataProvider) {
        if (this._dataProvider == dataProvider) {
            this._dataProvider = null;
        }
    }
}

