/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.api.helper;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.processing.parameters.MissingParameterException;
import org.eclipse.smila.processing.parameters.ParameterAccessor;
import org.eclipse.smila.search.api.QueryConstants;

public class QueryParameterAccessor
extends ParameterAccessor {
    private LinkedHashMap<String, QueryConstants.SortOrder> _sortByConfig;
    private LinkedHashMap<String, AnyMap> _filters;

    public QueryParameterAccessor(Blackboard blackboard, String queryRecordId) {
        super(blackboard, queryRecordId);
        this.setParameterAttribute(null);
    }

    public QueryParameterAccessor(Blackboard blackboard, AnyMap configuration, String queryRecordId) {
        super(blackboard, configuration, queryRecordId);
        this.setParameterAttribute(null);
    }

    public ParameterAccessor setCurrentRecord(String queryRecordId) {
        super.setCurrentRecord(queryRecordId);
        this.clearParsedConfigs();
        return this;
    }

    public ParameterAccessor setPipeletConfiguration(AnyMap config) {
        super.setPipeletConfiguration(config);
        this.clearParsedConfigs();
        return this;
    }

    public String getQuery() {
        return this.getParameter("query", null);
    }

    public String getQueryRequired() throws MissingParameterException {
        return this.getRequiredParameter("query");
    }

    public boolean hasQueryAttributes() {
        Any query = this.getParameterAny("query");
        return query != null && query.isMap();
    }

    public boolean hasQueryAttribute(String name) {
        Any query = this.getParameterAny("query");
        if (query != null && query.isMap()) {
            Any queryAttribute = (Any)((AnyMap)query).get((Object)name);
            return queryAttribute != null && (queryAttribute.isValue() || queryAttribute.isSeq());
        }
        return false;
    }

    public List<Value> getQueryAttributeValues(String name) {
        Any queryAttribute;
        Any query = this.getParameterAny("query");
        if (query != null && query.isMap() && (queryAttribute = (Any)((AnyMap)query).get((Object)name)) != null) {
            ArrayList<Value> values = new ArrayList<Value>();
            if (queryAttribute.isValue()) {
                values.add((Value)queryAttribute);
            } else if (queryAttribute.isSeq()) {
                for (Any element : (AnySeq)queryAttribute) {
                    if (!element.isValue()) continue;
                    values.add((Value)element);
                }
            }
            return values;
        }
        return null;
    }

    public int getMaxCount() {
        return this.getIntParameter("maxcount", 10);
    }

    public int getOffset() {
        return this.getIntParameter("offset", 0);
    }

    public double getThreshold() {
        return this.getFloatParameter("threshold", 0.0);
    }

    public String getLanguage() {
        return this.getParameter("language", null);
    }

    public String getIndexName() {
        return this.getParameter("indexname", null);
    }

    public List<String> getResultAttributes() {
        ArrayList<String> values = this.getParameters("resultAttributes");
        if (values == null || values.isEmpty()) {
            values = new ArrayList<String>();
            String value = this.getParameter("resultAttributes", null);
            if (value != null) {
                values.add(value);
            }
        }
        return values;
    }

    public LinkedHashMap<String, QueryConstants.SortOrder> getCachedSortByConfig() {
        if (this._sortByConfig == null) {
            this._sortByConfig = new LinkedHashMap();
            List annotations = this.getSubParameters("sortby");
            if (annotations != null) {
                for (AnyMap annotation : annotations) {
                    String attributeName = annotation.getStringValue("attribute");
                    String orderModeValue = annotation.getStringValue("order");
                    QueryConstants.SortOrder orderMode = QueryConstants.SortOrder.valueOf(orderModeValue.toUpperCase());
                    if (attributeName == null || orderMode == null) continue;
                    this._sortByConfig.put(attributeName, orderMode);
                }
            }
        }
        return this._sortByConfig;
    }

    public Iterator<String> getSortByAttributeNames() {
        return this.getCachedSortByConfig().keySet().iterator();
    }

    public QueryConstants.SortOrder getSortOrder(String attributeName) {
        return this.getCachedSortByConfig().get(attributeName);
    }

    public LinkedHashMap<String, AnyMap> getFilters() {
        if (this._filters == null) {
            this._filters = new LinkedHashMap();
            for (AnyMap filter : this.getSubParameters("filter")) {
                String attribute = filter.getStringValue("attribute");
                if (attribute == null) continue;
                this._filters.put(attribute, filter);
            }
        }
        return this._filters;
    }

    public boolean hasFilters() {
        return this.getFilters() != null && !this.getFilters().isEmpty();
    }

    public Iterator<String> getFilterAttributeNames() {
        return this.getFilters().keySet().iterator();
    }

    public AnyMap getFilter(String attributeName) {
        return this.getFilters().get(attributeName);
    }

    public Any getRankingConfig() {
        return this.getParameterAny("ranking");
    }

    public List<AnyMap> getFacetByConfig() {
        return this.getSubParameters("facetby");
    }

    private void clearParsedConfigs() {
        this._sortByConfig = null;
        this._filters = null;
    }

    public boolean hasGroupbyConfig() {
        Any groupby = this.getParameterAny("groupby");
        if (groupby != null) {
            return !groupby.isEmpty();
        }
        return false;
    }

    public AnyMap getGroupbyConfig() {
        Any groupby = this.getParameterAny("groupby");
        if (groupby != null) {
            return groupby.asMap();
        }
        return null;
    }

    public boolean hasHighlightConfig() {
        AnySeq highlight = this.getHighlightConfig();
        if (highlight != null) {
            return !highlight.isEmpty();
        }
        return false;
    }

    public AnySeq getHighlightConfig() {
        Any highlight = this.getParameterAny("highlight");
        if (highlight != null) {
            return highlight.asSeq();
        }
        return null;
    }

    public List<AnyMap> getFilterConfig() {
        return this.getSubParameters("filter");
    }

    public List<AnyMap> getGroupByConfig() {
        return this.getSubParameters("groupby");
    }

    public List<AnyMap> getSortByConfig() {
        return this.getSubParameters("sortby");
    }
}

