/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.http.server.util;

import java.io.File;
import org.eclipse.smila.http.server.JettyHandler;
import org.eclipse.smila.utils.config.ConfigUtils;
import org.eclipse.smila.utils.config.ConfigurationLoadException;
import org.osgi.service.component.ComponentContext;

public abstract class AJettyHandlerService
implements JettyHandler {
    public static final String PROPERTY_CONFIGBUNDLE = "configBundle";
    private String _rootContextPath;
    private String _configBundle;

    protected void activate(ComponentContext context) {
        this._rootContextPath = context.getProperties().get("rootContextPath").toString();
        Object configBundle = context.getProperties().get(PROPERTY_CONFIGBUNDLE);
        if (configBundle != null) {
            this._configBundle = configBundle.toString();
        }
    }

    @Override
    public String getRootContextPath() {
        return this._rootContextPath;
    }

    protected String getConfigBundle() {
        return this._configBundle;
    }

    protected String getConfigPathProperty(ComponentContext context, String property) {
        String path = context.getProperties().get(property).toString();
        if (this._configBundle != null) {
            File configFolder = ConfigUtils.getConfigFilePath((String)this._configBundle, (String)path);
            if (!configFolder.isDirectory()) {
                throw new ConfigurationLoadException("File does not exist or is not a folder: " + configFolder.getAbsolutePath());
            }
            return configFolder.getAbsolutePath();
        }
        return path;
    }
}

