/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.servlet;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.search.api.QueryConstants;
import org.eclipse.smila.search.api.helper.QueryBuilder;
import org.eclipse.smila.utils.collections.MultiValueMap;

public class ARequestParser {
    public static final String PREFIX_ATTRIBUTE = "A.";
    public static final String PREFIX_SORTBY = "sortby.";
    public static final String PREFIX_FILTER_VAL = "F.val.";
    public static final String PREFIX_FILTER_MIN = "F.min.";
    public static final String PREFIX_FILTER_MAX = "F.max.";
    public static final String PREFIX_RANKING = "R.";
    public static final String PREFIX_SOLR = "_solr.";
    private final MultiValueMap<String, String> _filterValues = new MultiValueMap();
    private final Map<String, String> _filterMin = new HashMap<String, String>();
    private final Map<String, String> _filterMax = new HashMap<String, String>();
    private AnyMap _ranking;

    protected void setupQuery(QueryBuilder builder) {
        if (this._ranking != null) {
            builder.setRanking((Any)this._ranking);
        }
        this.setupFilters(builder);
        this.setDefaultParameters(builder);
    }

    protected void setupFilters(QueryBuilder builder) {
        for (String attributeName : this._filterValues.keySet()) {
            this.setupListFilter(builder, attributeName);
        }
        HashSet<String> rangeFilterAttributes = new HashSet<String>();
        rangeFilterAttributes.addAll(this._filterMin.keySet());
        rangeFilterAttributes.addAll(this._filterMax.keySet());
        for (String attributeName : rangeFilterAttributes) {
            this.setupRangeFilter(builder, attributeName);
        }
    }

    protected void setupListFilter(QueryBuilder builder, String attributeName) {
        List values = (List)this._filterValues.get((Object)attributeName);
        if (values != null && values.size() > 0) {
            try {
                builder.addOneOfFilter(attributeName, values.toArray());
            }
            catch (Exception exception) {
            }
        }
    }

    protected void setupRangeFilter(QueryBuilder builder, String attributeName) {
        try {
            builder.addRangeFilter(attributeName, (Object)this._filterMin.get(attributeName), (Object)this._filterMax.get(attributeName));
        }
        catch (Exception exception) {
        }
    }

    protected void setDefaultParameters(QueryBuilder builder) {
        if (!builder.getMetadata().containsKey((Object)"maxcount")) {
            builder.setMaxCount(10);
        }
        if (!builder.getMetadata().containsKey((Object)"offset")) {
            builder.setOffset(0);
        }
    }

    protected void processParameter(QueryBuilder builder, String paramName, String[] paramValues) {
        ArrayList<String> nonEmptyValues = new ArrayList<String>(paramValues.length);
        String[] stringArray = paramValues;
        int n = paramValues.length;
        int n2 = 0;
        while (n2 < n) {
            String paramValue = stringArray[n2];
            if (!StringUtils.isEmpty((String)paramValue)) {
                nonEmptyValues.add(paramValue);
            }
            ++n2;
        }
        if (!nonEmptyValues.isEmpty()) {
            if (paramName.startsWith(PREFIX_RANKING)) {
                this.processRankingParameter(builder, paramName, nonEmptyValues);
            } else if (paramName.startsWith(PREFIX_FILTER_VAL)) {
                this.processFilterValue(paramName, nonEmptyValues);
            } else if (paramName.startsWith(PREFIX_FILTER_MIN)) {
                this.processFilterMin(paramName, nonEmptyValues);
            } else if (paramName.startsWith(PREFIX_FILTER_MAX)) {
                this.processFilterMax(paramName, nonEmptyValues);
            } else if (paramName.startsWith(PREFIX_SORTBY)) {
                this.processSortBy(builder, paramName, nonEmptyValues);
            } else if (paramName.startsWith(PREFIX_ATTRIBUTE)) {
                String name = paramName.substring(PREFIX_ATTRIBUTE.length());
                builder.setQueryAttribute(name, nonEmptyValues.toArray());
            } else {
                this.setCustomParameterValues(builder, paramName, nonEmptyValues);
            }
        }
    }

    private void processFilterMax(String paramName, List<String> paramValues) {
        String attributeName = paramName.substring(PREFIX_FILTER_MAX.length());
        if (!StringUtils.isEmpty((String)attributeName)) {
            this._filterMax.put(attributeName, paramValues.get(0));
        }
    }

    private void processFilterMin(String paramName, List<String> paramValues) {
        String attributeName = paramName.substring(PREFIX_FILTER_MIN.length());
        if (!StringUtils.isEmpty((String)attributeName)) {
            this._filterMin.put(attributeName, paramValues.get(0));
        }
    }

    private void processFilterValue(String paramName, List<String> paramValues) {
        String attributeName = paramName.substring(PREFIX_FILTER_VAL.length());
        if (!StringUtils.isEmpty((String)attributeName)) {
            for (String value : paramValues) {
                if (StringUtils.isEmpty((String)value)) continue;
                this._filterValues.add((Object)attributeName, (Object)value);
            }
        }
    }

    private void processRankingParameter(QueryBuilder builder, String paramName, List<String> paramValues) {
        String attributeAndParameterName = paramName.substring(PREFIX_RANKING.length());
        int dotIndex = attributeAndParameterName.indexOf(46);
        String valueName = null;
        String attributeName = null;
        if (dotIndex < 0) {
            valueName = attributeAndParameterName;
        } else {
            valueName = attributeAndParameterName.substring(0, dotIndex);
            attributeName = attributeAndParameterName.substring(dotIndex + 1);
        }
        Value paramValue = builder.getFactory().createStringValue(paramValues.get(0));
        if (this._ranking == null) {
            this._ranking = builder.getFactory().createAnyMap();
        }
        if (attributeName != null) {
            AnyMap attributeRanking = this._ranking.getMap(attributeName);
            if (attributeRanking == null) {
                attributeRanking = builder.getFactory().createAnyMap();
                this._ranking.put(attributeName, (Any)attributeRanking);
            }
            attributeRanking.put(valueName, (Any)paramValue);
        } else {
            this._ranking.put(valueName, (Any)paramValue);
        }
    }

    protected void setCustomParameterValues(QueryBuilder builder, String paramName, List<String> paramValues) {
        if (paramValues.size() == 1) {
            builder.setParameter(paramName, paramValues.get(0));
        } else {
            for (String value : paramValues) {
                builder.addParameter(paramName, value);
            }
        }
    }

    private void processSortBy(QueryBuilder builder, String paramName, List<String> paramValues) {
        String attributeName = paramName.substring(PREFIX_SORTBY.length());
        if (!StringUtils.isEmpty((String)attributeName)) {
            try {
                QueryConstants.SortOrder orderMode = QueryConstants.SortOrder.valueOf((String)paramValues.get(0).toUpperCase());
                builder.addSortBy(attributeName, orderMode);
            }
            catch (Exception exception) {
            }
        }
    }
}

