/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.servlet.solr;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.CoreAdminParams;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.solr.SolrConfig;
import org.eclipse.smila.solr.SolrOperationService;
import org.eclipse.smila.solr.SolrServerService;
import org.eclipse.smila.utils.service.ServiceUtils;

public class IndexNamesHelper {
    private static final Log _log = LogFactory.getLog(IndexNamesHelper.class);

    public static Collection<String> getIndexNames() throws InterruptedException {
        SolrOperationService operationService = (SolrOperationService)ServiceUtils.getService(SolrOperationService.class);
        SolrConfig.Mode mode = IndexNamesHelper.getMode();
        AnySeq indices = null;
        switch (mode) {
            case CLOUD: {
                indices = IndexNamesHelper.getCollections(operationService);
                break;
            }
            case EMBEDDED: 
            case HTTP: {
                indices = IndexNamesHelper.getCores(operationService);
                break;
            }
            default: {
                throw new NotImplementedException(mode.toString());
            }
        }
        if (!CollectionUtils.isEmpty((Collection)indices)) {
            return indices.asStrings();
        }
        return CollectionUtils.EMPTY_COLLECTION;
    }

    private static AnySeq getCollections(SolrOperationService operationService) {
        Any response = operationService.processAdminOperation(CollectionParams.CollectionAction.LIST.name(), null);
        return response.asMap().getSeq("collections");
    }

    private static AnySeq getCores(SolrOperationService operationService) {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("indexInfo", new String[]{"false"});
        Any response = operationService.processAdminOperation(CoreAdminParams.CoreAdminAction.STATUS.name(), params);
        AnySeq cores = DataFactory.DEFAULT.createAnySeq();
        if (response != null && response.isMap()) {
            Iterator coreNames = response.asMap().getMap("status").keySet().iterator();
            while (coreNames.hasNext()) {
                cores.add((String)coreNames.next());
            }
        }
        return cores;
    }

    private static SolrConfig.Mode getMode() throws InterruptedException {
        SolrServerService serverService = (SolrServerService)ServiceUtils.getService(SolrServerService.class);
        return serverService.getConfig().getMode();
    }
}

