/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.blackboard.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.binarystorage.BinaryStorageService;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.blackboard.BlackboardFactory;
import org.eclipse.smila.blackboard.impl.BlackboardImpl;
import org.eclipse.smila.datamodel.filter.RecordFilterHelper;
import org.eclipse.smila.recordstorage.RecordStorage;
import org.eclipse.smila.utils.config.ConfigUtils;
import org.osgi.service.component.ComponentContext;

public class BlackboardFactoryImpl
implements BlackboardFactory {
    private static final String BUNDLE_ID = "org.eclipse.smila.blackboard";
    private final Log _log = LogFactory.getLog(this.getClass());
    private RecordStorage _recordStorage;
    private BinaryStorageService _binaryStorage;
    private RecordFilterHelper _filterHelper;

    @Override
    public Blackboard createBlackboard(boolean useRecordStorage, boolean useBinaryStorage) throws BlackboardAccessException {
        BlackboardImpl blackboard = (BlackboardImpl)this.createTransientBlackboard();
        if (useRecordStorage) {
            if (this._recordStorage != null) {
                blackboard.setRecordStorage(this._recordStorage);
            } else {
                throw new BlackboardAccessException("No record storage available for blackboard.");
            }
        }
        if (useBinaryStorage) {
            if (this._binaryStorage != null) {
                blackboard.setBinaryStorage(this._binaryStorage);
            } else {
                throw new BlackboardAccessException("No binary storage available for blackboard.");
            }
        }
        return blackboard;
    }

    @Override
    public Blackboard createPersistingBlackboard() throws BlackboardAccessException {
        return this.createBlackboard(this._recordStorage != null, true);
    }

    @Override
    public Blackboard createTransientBlackboard() {
        return new BlackboardImpl(this._filterHelper);
    }

    protected void activate(ComponentContext context) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Activating " + this.getClass()));
        }
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            try {
                this._filterHelper = new RecordFilterHelper(ConfigUtils.getConfigStream((String)BUNDLE_ID, (String)"RecordFilters.xml"));
                if (this._log.isInfoEnabled()) {
                    this._log.info((Object)"BlackboardService started");
                }
            }
            catch (Exception exception) {
                if (this._log.isErrorEnabled()) {
                    this._log.error((Object)("Activation of " + this.getClass() + " failed"));
                    throw new RuntimeException(exception);
                }
                Thread.currentThread().setContextClassLoader(oldCL);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
    }

    public void setRecordStorage(RecordStorage recordStorage) {
        this._recordStorage = recordStorage;
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)"RecordStorage is bound");
        }
    }

    public void unsetRecordStorage(RecordStorage recordStorage) {
        if (recordStorage == this._recordStorage) {
            this._recordStorage = null;
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)"RecordStorage is unbound");
        }
    }

    public void setBinaryStorage(BinaryStorageService binaryStorage) {
        this._binaryStorage = binaryStorage;
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)"BinaryStorage is bound");
        }
    }

    public void unsetBinaryStorage(BinaryStorageService binaryStorage) {
        if (binaryStorage == this._binaryStorage) {
            this._binaryStorage = null;
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)"BinaryStorage is unbound");
        }
    }
}

