/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.axis2.service;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.activation.DataHandler;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.engine.MessageReceiver;
import org.apache.axis2.receivers.AbstractMessageReceiver;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.axis2.OdeFault;
import org.apache.ode.axis2.deploy.DeploymentPoller;
import org.apache.ode.axis2.hooks.ODEAxisService;
import org.apache.ode.bpel.iapi.BpelServer;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.ProcessStore;
import org.apache.ode.il.OMUtils;
import org.apache.ode.utils.fs.FileUtils;

public class DeploymentWebService {
    private static final Log __log = LogFactory.getLog(DeploymentWebService.class);
    private final OMNamespace _pmapi = OMAbstractFactory.getOMFactory().createOMNamespace("http://www.apache.org/ode/pmapi", "pmapi");
    private File _deployPath;
    private DeploymentPoller _poller;
    private ProcessStore _store;

    public void enableService(AxisConfiguration axisConfiguration, BpelServer bpelServer, ProcessStore processStore, DeploymentPoller deploymentPoller, String string, String string2) {
        this._deployPath = new File(string2, "processes");
        this._store = processStore;
        try {
            WSDLReader wSDLReader = WSDLFactory.newInstance().newWSDLReader();
            wSDLReader.setFeature("javax.wsdl.verbose", false);
            File file = new File(string + "/deploy.wsdl");
            Definition definition = wSDLReader.readWSDL(file.toURI().toString());
            AxisService axisService = ODEAxisService.createService(axisConfiguration, new QName("http://www.apache.org/ode/deployapi", "DeploymentService"), "DeploymentPort", "DeploymentService", definition, (MessageReceiver)new DeploymentMessageReceiver());
            axisConfiguration.addService(axisService);
            this._poller = deploymentPoller;
        }
        catch (WSDLException wSDLException) {
            wSDLException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static void copyInputStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
        outputStream.close();
    }

    class DeploymentMessageReceiver
    extends AbstractMessageReceiver {
        DeploymentMessageReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invokeBusinessLogic(MessageContext messageContext) throws AxisFault {
            boolean bl;
            block28: {
                String string = messageContext.getAxisOperation().getName().getLocalPart();
                SOAPFactory sOAPFactory = this.getSOAPFactory(messageContext);
                bl = false;
                try {
                    if (string.equals("deploy")) {
                        OMElement oMElement;
                        OMElement oMElement2 = messageContext.getEnvelope().getBody().getFirstElement().getFirstElement();
                        OMElement oMElement3 = (OMElement)oMElement2.getNextOMSibling();
                        OMElement oMElement4 = oMElement = oMElement3 == null ? null : oMElement3.getFirstElement();
                        if (oMElement == null || !oMElement3.getQName().getLocalPart().equals("package") || !oMElement.getQName().getLocalPart().equals("zip")) {
                            throw new OdeFault("Your message should contain an element named 'package' with a 'zip' element");
                        }
                        OMText oMText = (OMText)oMElement.getFirstOMChild();
                        if (oMText == null) {
                            throw new OdeFault("Empty binary node under <zip> element");
                        }
                        oMText.setOptimize(true);
                        try {
                            DeploymentWebService.this._poller.hold();
                            File file = new File(DeploymentWebService.this._deployPath, oMElement2.getText() + "-" + DeploymentWebService.this._store.getCurrentVersion());
                            file.mkdir();
                            this.unzip(file, (DataHandler)oMText.getDataHandler());
                            File file2 = new File(file, "deploy.xml");
                            if (!file2.exists()) {
                                throw new OdeFault("The deployment doesn't appear to contain a deployment descriptor in its root directory named deploy.xml, aborting.");
                            }
                            Collection collection = DeploymentWebService.this._store.deploy(file);
                            File file3 = new File(DeploymentWebService.this._deployPath, file.getName() + ".deployed");
                            file3.createNewFile();
                            DeploymentWebService.this._poller.markAsDeployed(file);
                            __log.info((Object)("Deployment of artifact " + file.getName() + " successful."));
                            OMElement oMElement5 = sOAPFactory.createOMElement("response", null);
                            if (__log.isDebugEnabled()) {
                                __log.debug((Object)("Deployed package: " + file.getName()));
                            }
                            OMElement oMElement6 = sOAPFactory.createOMElement("name", null);
                            oMElement6.setText(file.getName());
                            oMElement5.addChild((OMNode)oMElement6);
                            for (QName qName : collection) {
                                if (__log.isDebugEnabled()) {
                                    __log.debug((Object)("Deployed PID: " + qName));
                                }
                                oMElement6 = sOAPFactory.createOMElement("id", null);
                                oMElement6.setText(qName);
                                oMElement5.addChild((OMNode)oMElement6);
                            }
                            this.sendResponse(sOAPFactory, messageContext, "deployResponse", oMElement5);
                            break block28;
                        }
                        finally {
                            DeploymentWebService.this._poller.release();
                        }
                    }
                    if (string.equals("undeploy")) {
                        OMElement oMElement = messageContext.getEnvelope().getBody().getFirstElement().getFirstElement();
                        String string2 = oMElement.getText();
                        File file = new File(DeploymentWebService.this._deployPath, string2);
                        if (!file.exists()) {
                            throw new OdeFault("Couldn't find deployment package " + string2 + " in directory " + DeploymentWebService.this._deployPath);
                        }
                        try {
                            DeploymentWebService.this._poller.hold();
                            Collection collection = DeploymentWebService.this._store.undeploy(file);
                            File file4 = new File(DeploymentWebService.this._deployPath, string2 + ".deployed");
                            file4.delete();
                            FileUtils.deepDelete((File)new File(DeploymentWebService.this._deployPath, string2));
                            OMElement oMElement7 = sOAPFactory.createOMElement("response", null);
                            oMElement7.setText("" + (collection.size() > 0));
                            this.sendResponse(sOAPFactory, messageContext, "undeployResponse", oMElement7);
                            DeploymentWebService.this._poller.markAsUndeployed(file);
                            break block28;
                        }
                        finally {
                            DeploymentWebService.this._poller.release();
                        }
                    }
                    if (string.equals("listDeployedPackages")) {
                        Collection collection = DeploymentWebService.this._store.getPackages();
                        OMElement oMElement = sOAPFactory.createOMElement("deployedPackages", null);
                        for (String string3 : collection) {
                            OMElement oMElement8 = sOAPFactory.createOMElement(new QName("http://www.apache.org/ode/deployapi", "name"));
                            oMElement8.setText(string3);
                            oMElement.addChild((OMNode)oMElement8);
                        }
                        this.sendResponse(sOAPFactory, messageContext, "listDeployedPackagesResponse", oMElement);
                    } else if (string.equals("listProcesses")) {
                        OMElement oMElement = messageContext.getEnvelope().getBody().getFirstElement().getFirstElement();
                        List list = DeploymentWebService.this._store.listProcesses(oMElement.getText());
                        OMElement oMElement9 = sOAPFactory.createOMElement("processIds", null);
                        for (QName qName : list) {
                            OMElement oMElement10 = sOAPFactory.createOMElement("id", null);
                            oMElement10.setText(qName);
                            oMElement9.addChild((OMNode)oMElement10);
                        }
                        this.sendResponse(sOAPFactory, messageContext, "listProcessResponse", oMElement9);
                    } else if (string.equals("getProcessPackage")) {
                        OMElement oMElement = messageContext.getEnvelope().getBody().getFirstElement().getFirstElement();
                        ProcessConf processConf = DeploymentWebService.this._store.getProcessConfiguration(OMUtils.getTextAsQName((OMElement)oMElement));
                        if (processConf == null) {
                            throw new OdeFault("Could not find process: " + oMElement.getTextAsQName());
                        }
                        String string4 = DeploymentWebService.this._store.getProcessConfiguration(OMUtils.getTextAsQName((OMElement)oMElement)).getPackage();
                        OMElement oMElement11 = sOAPFactory.createOMElement("packageName", null);
                        oMElement11.setText(string4);
                        this.sendResponse(sOAPFactory, messageContext, "getProcessPackageResponse", oMElement11);
                    } else {
                        bl = true;
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    for (throwable2 = throwable; throwable2.getCause() != null && throwable2.getCause() != throwable2; throwable2 = throwable2.getCause()) {
                    }
                    __log.warn((Object)("Invocation of operation " + string + " failed"), throwable);
                    throw new OdeFault("Invocation of operation " + string + " failed: " + throwable2.toString(), throwable);
                }
            }
            if (bl) {
                throw new OdeFault("Unknown operation: '" + messageContext.getAxisOperation().getName() + "'");
            }
        }

        private File buildUnusedDir(File file, String string) {
            int n = 1;
            while (new File(file, string + "-" + n).exists()) {
                ++n;
            }
            return new File(file, string + "-" + n);
        }

        private void unzip(File file, DataHandler dataHandler) throws AxisFault {
            try {
                ZipEntry zipEntry;
                ZipInputStream zipInputStream = new ZipInputStream(dataHandler.getDataSource().getInputStream());
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    if (zipEntry.isDirectory()) {
                        __log.debug((Object)("Extracting directory: " + zipEntry.getName()));
                        new File(file, zipEntry.getName()).mkdir();
                        continue;
                    }
                    __log.debug((Object)("Extracting file: " + zipEntry.getName()));
                    File file2 = new File(file, zipEntry.getName());
                    if (!file2.getParentFile().exists()) {
                        file2.getParentFile().mkdirs();
                    }
                    DeploymentWebService.copyInputStream(zipInputStream, new BufferedOutputStream(new FileOutputStream(file2)));
                }
                zipInputStream.close();
            }
            catch (IOException iOException) {
                throw new OdeFault("An error occured on deployment.", iOException);
            }
        }

        private void sendResponse(SOAPFactory sOAPFactory, MessageContext messageContext, String string, OMElement oMElement) throws AxisFault {
            MessageContext messageContext2 = Utils.createOutMessageContext((MessageContext)messageContext);
            messageContext2.getOperationContext().addMessageContext(messageContext2);
            SOAPEnvelope sOAPEnvelope = sOAPFactory.getDefaultEnvelope();
            messageContext2.setEnvelope(sOAPEnvelope);
            OMElement oMElement2 = sOAPFactory.createOMElement(string, DeploymentWebService.this._pmapi);
            oMElement2.addChild((OMNode)oMElement);
            sOAPEnvelope.getBody().addChild((OMNode)oMElement2);
            AxisEngine.send((MessageContext)messageContext2);
        }
    }
}

