/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import org.eclipse.smila.datamodel.Attachment;

public class InMemoryAttachment
implements Attachment,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String _name;
    private final byte[] _content;

    public InMemoryAttachment(String name, byte[] content) {
        if (name == null) {
            throw new IllegalArgumentException("attachment name must not be null");
        }
        if (content == null) {
            throw new IllegalArgumentException("attachment content must not be null");
        }
        this._name = name;
        this._content = content;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public long size() {
        return this._content.length;
    }

    @Override
    public byte[] getAsBytes() {
        return this._content;
    }

    @Override
    public byte[] getAsBytes(int length) {
        if (length >= this._content.length) {
            return this._content;
        }
        return Arrays.copyOf(this._content, length);
    }

    @Override
    public InputStream getAsStream() {
        return new ByteArrayInputStream(this._content);
    }

    @Override
    public void dispose() {
    }

    public String toString() {
        return "InMemoryAttachment '" + this._name + "', size " + this.size();
    }
}

