/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.datamodel.validation;

import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.validation.InvalidRecordException;
import org.eclipse.smila.datamodel.validation.RecordValidator;

public class RecordIdValidator
implements RecordValidator {
    @Override
    public void validate(Record record) throws InvalidRecordException {
        AnyMap recordData = record.getMetadata();
        Any idAttribute = (Any)recordData.get("_recordid");
        if (idAttribute == null) {
            throw new InvalidRecordException("Record attribute '_recordid' is missing.");
        }
        if (!idAttribute.isValue()) {
            throw new InvalidRecordException("Record attribute '_recordid' is no single value.");
        }
        if (!idAttribute.isString()) {
            recordData.put("_recordid", idAttribute.asValue().asString());
        }
        if (recordData.getStringValue("_recordid").isEmpty()) {
            throw new InvalidRecordException("Record attribute '_recordid' value is empty.");
        }
    }
}

