/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.parameters.ParameterAccessor;
import org.eclipse.smila.processing.util.ResultCollector;

public class DocumentSplitterPipelet
implements Pipelet {
    public static final String PROP_PARTS_ATTRIBUTE = "partsAttribute";
    public static final String DOCUMENT_ID = "_documentId";
    public static final String SPLIT_ID_SEPARATOR = "###";
    private final Log _log = LogFactory.getLog(this.getClass());
    private AnyMap _configuration;

    public void configure(AnyMap configuration) throws ProcessingException {
        this._configuration = configuration;
    }

    public String[] process(Blackboard blackboard, String[] recordIds) throws ProcessingException {
        ParameterAccessor paramAccessor = new ParameterAccessor(blackboard, this._configuration);
        ResultCollector resultCollector = new ResultCollector(paramAccessor, this._log, false);
        String[] stringArray = recordIds;
        int n = recordIds.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            try {
                paramAccessor.setCurrentRecord(id);
                String partsAttribute = paramAccessor.getParameter(PROP_PARTS_ATTRIBUTE, null);
                Record record = blackboard.getRecord(id);
                if (partsAttribute != null && record.getMetadata().containsKey((Object)partsAttribute)) {
                    this.splitRecord(record, blackboard, partsAttribute, resultCollector);
                } else {
                    resultCollector.addResult(id);
                }
            }
            catch (Exception ex) {
                resultCollector.addFailedResult(id, ex);
            }
            ++n2;
        }
        return resultCollector.getResultIds();
    }

    private void splitRecord(Record record, Blackboard blackboard, String partsAttribute, ResultCollector resultCollector) throws BlackboardAccessException, ProcessingException {
        Any parts = (Any)record.getMetadata().get((Object)partsAttribute);
        if (!parts.isSeq()) {
            throw new ProcessingException("Parts attribute '" + partsAttribute + "' has invalid value, must be a Sequence, but was: " + parts);
        }
        if (parts.asSeq().isEmpty()) {
            record.getMetadata().remove((Object)partsAttribute);
            resultCollector.addResult(record.getId());
        } else {
            int i = 0;
            while (i < parts.asSeq().size()) {
                Any part = (Any)parts.asSeq().get(i);
                if (!part.isMap()) {
                    throw new ProcessingException("Part " + (i + 1) + " + in parts attribute '" + partsAttribute + "' has invalid value, must be a Map, but was: " + part);
                }
                String splitId = String.valueOf(record.getId()) + SPLIT_ID_SEPARATOR + i;
                Record splitRecord = blackboard.getDataFactory().createRecord(splitId);
                AnyMap splitMetadata = DataFactory.DEFAULT.cloneAnyMap(record.getMetadata());
                splitMetadata.remove((Object)"_recordid");
                splitRecord.getMetadata().putAll((Map)splitMetadata);
                splitRecord.getMetadata().put(DOCUMENT_ID, record.getId());
                splitRecord.getMetadata().remove((Object)partsAttribute);
                splitRecord.getMetadata().putAll((Map)part.asMap());
                blackboard.setRecord(splitRecord);
                resultCollector.addResult(splitId);
                ++i;
            }
        }
    }
}

