/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.parameters.ParameterAccessor;
import org.eclipse.smila.processing.util.ResultCollector;

public class FileReaderPipelet
implements Pipelet {
    public static final String PROPERTY_PATH_ATTRIBUTE = "pathAttribute";
    public static final String PROPERTY_CONTENT_ATTACHMENT = "contentAttachment";
    private final Log _log = LogFactory.getLog(this.getClass());
    private AnyMap _config;

    public void configure(AnyMap configuration) throws ProcessingException {
        this._config = configuration;
    }

    public String[] process(Blackboard blackboard, String[] recordIds) throws ProcessingException {
        ParameterAccessor paramAccessor = new ParameterAccessor(blackboard, this._config);
        ResultCollector resultCollector = new ResultCollector(paramAccessor, this._log, false);
        String[] stringArray = recordIds;
        int n = recordIds.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            try {
                paramAccessor.setCurrentRecord(id);
                String pathAttributeName = paramAccessor.getRequiredParameter(PROPERTY_PATH_ATTRIBUTE);
                String contentAttachmentName = paramAccessor.getRequiredParameter(PROPERTY_CONTENT_ATTACHMENT);
                String path = blackboard.getMetadata(id).getStringValue(pathAttributeName);
                File attachmentFile = new File(path);
                blackboard.setAttachmentFromFile(id, contentAttachmentName, attachmentFile);
                resultCollector.addResult(id);
            }
            catch (Exception e) {
                resultCollector.addFailedResult(id, (Exception)new ProcessingException("Error in FileReaderPipelet processing Id " + id, (Throwable)e));
            }
            ++n2;
        }
        return resultCollector.getResultIds();
    }
}

