/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.ipc.IpcRecordWriter;
import org.eclipse.smila.objectstore.ObjectStoreService;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.parameters.ParameterAccessor;
import org.eclipse.smila.processing.util.ResultCollector;
import org.eclipse.smila.utils.service.ServiceUtils;

public class StoreWriterPipelet
implements Pipelet {
    public static final String PARAM_STORE = "store";
    public static final String PARAM_OBJECT_ID = "objectId";
    private final Log _log = LogFactory.getLog(this.getClass());
    protected AnyMap _configuration;
    private ObjectStoreService _objectStore;
    private final IpcRecordWriter _recordWriter = new IpcRecordWriter();

    public void configure(AnyMap configuration) throws ProcessingException {
        this._configuration = configuration;
    }

    public String[] process(Blackboard blackboard, String[] recordIds) throws ProcessingException {
        ObjectStoreService objectStore = this.getObjectStoreService();
        ParameterAccessor paramAccessor = new ParameterAccessor(blackboard, this._configuration);
        ResultCollector resultCollector = new ResultCollector(paramAccessor, this._log, false);
        if (recordIds != null) {
            String[] stringArray = recordIds;
            int n = recordIds.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                try {
                    paramAccessor.setCurrentRecord(id);
                    Record record = blackboard.getRecord(id);
                    String store = paramAccessor.getRequiredParameter(PARAM_STORE);
                    String objectId = paramAccessor.getRequiredParameter(PARAM_OBJECT_ID);
                    byte[] recordAsBon = this._recordWriter.writeBinaryObject(record);
                    objectStore.putObject(store, objectId, recordAsBon);
                    resultCollector.addResult(id);
                }
                catch (Exception e) {
                    resultCollector.addFailedResult(id, e);
                }
                ++n2;
            }
        }
        return resultCollector.getResultIds();
    }

    private synchronized ObjectStoreService getObjectStoreService() throws ProcessingException {
        if (this._objectStore == null) {
            try {
                this._objectStore = (ObjectStoreService)ServiceUtils.getService(ObjectStoreService.class);
            }
            catch (Exception ex) {
                this._log.warn((Object)"Error while waiting for ObjectStoreService service to come up.", (Throwable)ex);
            }
            if (this._objectStore == null) {
                throw new ProcessingException("No ObjectStoreService service available, giving up");
            }
        }
        return this._objectStore;
    }
}

