/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.crawler.web;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.importing.crawler.web.Fetcher;
import org.eclipse.smila.importing.crawler.web.WebCrawlerConstants;
import org.eclipse.smila.importing.crawler.web.WebCrawlerException;
import org.eclipse.smila.importing.crawler.web.WebCrawlingContext;
import org.eclipse.smila.importing.util.PropertyNameMapper;
import org.eclipse.smila.taskworker.TaskContext;
import org.eclipse.smila.taskworker.Worker;
import org.eclipse.smila.taskworker.input.RecordInput;
import org.eclipse.smila.taskworker.output.RecordOutput;

public class WebFetcherWorker
implements Worker {
    private static final String WORKER_NAME = "webFetcher";
    private static final String INPUT_SLOT = "linksToFetch";
    private static final String OUTPUT_SLOT = "fetchedLinks";
    private final Log _log = LogFactory.getLog(this.getClass());
    private Fetcher _fetcher;

    public String getName() {
        return WORKER_NAME;
    }

    public void perform(TaskContext taskContext) throws Exception {
        Record record;
        RecordInput recordInput = taskContext.getInputs().getAsRecordInput(INPUT_SLOT);
        RecordOutput recordOutput = taskContext.getOutputs().getAsRecordOutput(OUTPUT_SLOT);
        Long sleepTime = taskContext.getTaskParameters().getLongValue("waitBetweenRequests");
        WebCrawlingContext context = new WebCrawlingContext(taskContext);
        context.setCurrentInputBulkId(recordInput.getObjectName());
        PropertyNameMapper mapper = context.getMapper();
        do {
            record = recordInput.getRecord();
            boolean writeRecord = true;
            if (record == null) continue;
            if (!record.hasAttachment((String)mapper.get("httpContent").get(0))) {
                this.waitBetweenRequests(sleepTime);
                writeRecord = this.fetchContent(record, context);
            }
            if (!writeRecord) continue;
            mapper.mapNames(record, WebCrawlerConstants.PROPERTY_NAMES);
            recordOutput.writeRecord(record);
            if (!this._log.isDebugEnabled()) continue;
            this._log.debug((Object)("added record " + record.getId()));
        } while (record != null && !taskContext.isCanceled());
    }

    private boolean fetchContent(Record record, WebCrawlingContext context) throws WebCrawlerException {
        long time = context.getTaskContext().getTimestamp();
        try {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("fetching content for record " + record.getId()));
            }
            this._fetcher.fetch(record.getMetadata().getStringValue((String)context.getMapper().get("httpUrl").get(0)), record, context);
            return true;
        }
        catch (WebCrawlerException e) {
            boolean ignoreFetchError;
            StringBuilder message = new StringBuilder("Failed to fetch link for record ").append(record.getId());
            boolean dropRecord = e.isRecoverable() && context.getErrorHandling() == WebCrawlerConstants.ErrorHandling.DROP;
            boolean bl = ignoreFetchError = e.isRecoverable() && context.getErrorHandling() == WebCrawlerConstants.ErrorHandling.IGNORE;
            if (dropRecord && !ignoreFetchError) {
                message.append(", record will be dropped.");
            }
            context.getTaskLog().warn(message.toString(), (Throwable)((Object)e));
            if (e.isRecoverable() && context.getErrorHandling() == WebCrawlerConstants.ErrorHandling.RETRY) {
                throw e;
            }
            boolean bl2 = !dropRecord || ignoreFetchError;
            return bl2;
        }
        finally {
            context.getTaskContext().measureTime("fetchContent", time);
        }
    }

    private void waitBetweenRequests(Long sleepTime) {
        if (sleepTime != null && sleepTime > 0L) {
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void setFetcher(Fetcher fetcher) {
        this._fetcher = fetcher;
    }

    public void unsetFetcher(Fetcher fetcher) {
        if (this._fetcher == fetcher) {
            this._fetcher = null;
        }
    }
}

