/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.crawler.web.utils;

import java.util.UUID;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.utils.digest.DigestHelper;

public final class DeltaHash {
    private DeltaHash() {
    }

    public static void calculate(Record record) {
        AnyMap metadata = record.getMetadata();
        String deltaHash = null;
        if (record.hasAttachment("httpContent")) {
            deltaHash = DigestHelper.calculateDigest((byte[])record.getAttachmentAsBytes("httpContent"));
        } else {
            Any lastModified = null;
            lastModified = (Any)metadata.get((Object)"httpLastModified");
            if (lastModified != null) {
                deltaHash = lastModified.toString();
            } else {
                Any contentLength = null;
                contentLength = (Any)metadata.get((Object)"httpSize");
                if (contentLength != null) {
                    deltaHash = contentLength.toString();
                    deltaHash = String.valueOf(deltaHash) + "-" + metadata.get((Object)"httpContenttype");
                } else {
                    deltaHash = UUID.randomUUID().toString();
                }
            }
        }
        if (deltaHash != null) {
            metadata.put("_deltaHash", deltaHash);
        }
    }
}

