/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.crawler.web.utils;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.utils.URIUtils;

public final class UriHelper {
    private static final String SCHEME_HTTP = "http";
    private static final String SCHEME_HTTPS = "https";
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final int DEFAULT_HTTPS_PORT = 443;

    private UriHelper() {
    }

    public static String makeAbsolute(String baseUriString, String uriString) throws URISyntaxException {
        URI uri = new URI(uriString);
        if (uri.isAbsolute()) {
            return uri.toString();
        }
        URI baseUri = new URI(baseUriString);
        if (!baseUri.isAbsolute()) {
            return null;
        }
        URI absUri = URIUtils.resolve((URI)baseUri, (URI)uri);
        return absUri.toString();
    }

    public static String getHost(String url) throws MalformedURLException {
        return new URL(url).getHost();
    }

    public static String getHostAndPort(String urlString) throws MalformedURLException {
        return UriHelper.getHostAndPort(new URL(urlString));
    }

    public static String getHostAndPort(URL url) throws MalformedURLException {
        int portNum = url.getPort();
        if (portNum < 0) {
            if (url.getHost() == null || "".equals(url.getHost())) {
                throw new MalformedURLException("No host and port in URL: " + url);
            }
            return url.getHost();
        }
        return String.valueOf(url.getHost()) + ":" + portNum;
    }

    public static String getDomain(String host) {
        int lastDot;
        int firstDot = host.indexOf(".");
        if (firstDot != (lastDot = host.lastIndexOf("."))) {
            return host.substring(firstDot + 1);
        }
        return host;
    }

    public static String normalizeUrl(String context, String urlString) throws URISyntaxException {
        String path;
        String urlWithoutFragment = UriHelper.removeFragment(urlString);
        URI uri = UriHelper.createUri(context, urlWithoutFragment);
        if (uri == null || uri.isOpaque()) {
            return null;
        }
        URI u = uri.normalize();
        String scheme = u.getScheme();
        if (scheme != null) {
            scheme = scheme.toLowerCase();
        }
        String userInfo = u.getUserInfo();
        String host = u.getHost();
        if (host != null) {
            host = host.toLowerCase();
        }
        int port = u.getPort();
        if (SCHEME_HTTP.equals(scheme) && port == 80) {
            port = -1;
        }
        if (SCHEME_HTTPS.equals(scheme) && port == 443) {
            port = -1;
        }
        if ((path = u.getPath()).isEmpty()) {
            path = "/";
        }
        String query = u.getQuery();
        String normalizedUrl = new URI(scheme, userInfo, host, port, path, query, null).toString();
        return normalizedUrl;
    }

    private static String removeFragment(String urlString) {
        int fragmentStart = urlString.indexOf(35);
        if (fragmentStart > 0) {
            return urlString.substring(0, fragmentStart);
        }
        return urlString;
    }

    private static URI createUri(String context, String urlWithoutFragment) throws URISyntaxException {
        URL baseUrl = null;
        if (!StringUtils.isEmpty((String)context)) {
            try {
                baseUrl = new URL(context);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        URI uri = null;
        try {
            uri = new URI(urlWithoutFragment);
            if (!uri.isAbsolute() && baseUrl != null) {
                uri = URIUtils.resolve((URI)baseUrl.toURI(), (URI)uri);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            try {
                URL url = new URL(baseUrl, urlWithoutFragment);
                uri = new URI(url.getProtocol(), url.getAuthority(), url.getPath(), url.getQuery(), null);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return uri;
    }
}

