/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.parameters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.InvalidValueTypeException;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.processing.parameters.MissingParameterException;

public class ParameterAccessor {
    public static final String DEFAULT_PARAMETERS_ATTRIBUTE = "_parameters";
    protected final Blackboard _blackboard;
    protected String _recordId;
    protected AnyMap _config;
    protected String _parametersAttribute = "_parameters";

    public ParameterAccessor(AnyMap configuration) {
        this._blackboard = null;
        this._config = configuration;
    }

    public ParameterAccessor(Blackboard blackboard) {
        this._blackboard = blackboard;
    }

    public ParameterAccessor(Blackboard blackboard, AnyMap configuration) {
        this(blackboard);
        this._config = configuration;
    }

    public ParameterAccessor(Blackboard blackboard, AnyMap configuration, String recordId) {
        this(blackboard, configuration);
        this._recordId = recordId;
    }

    public ParameterAccessor(Blackboard blackboard, String recordId) {
        this(blackboard);
        this._recordId = recordId;
    }

    public void setParameterAttribute(String parameterAttribute) {
        this._parametersAttribute = parameterAttribute;
    }

    public String getParameterAttribute() {
        return this._parametersAttribute;
    }

    public ParameterAccessor setCurrentRecord(String recordId) {
        this._recordId = recordId;
        return this;
    }

    public ParameterAccessor setPipeletConfiguration(AnyMap config) {
        this._config = config;
        return this;
    }

    public String getParameter(String name, String defaultValue) {
        String value = null;
        if (this._recordId != null) {
            value = this.getRecordParameter(name, this._recordId);
        }
        if (value == null && this._config != null) {
            value = this.getParameterFromMap(name, this._config);
        }
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public String getRequiredParameter(String name) throws MissingParameterException {
        String value = this.getParameter(name, null);
        if (value == null) {
            throw new MissingParameterException("no single value for required parameter " + name);
        }
        return value;
    }

    public List<String> getParameters(String name) {
        List<String> values = null;
        if (this._recordId != null) {
            values = this.getRecordParameters(name, this._recordId);
        }
        if (values == null && this._config != null) {
            values = this.getParametersFromMap(name, this._config);
        }
        if (values == null) {
            values = Collections.EMPTY_LIST;
        }
        return values;
    }

    public List<String> getRequiredParameters(String name) throws MissingParameterException {
        List<String> values = this.getParameters(name);
        if (values == null || values.isEmpty()) {
            throw new MissingParameterException("no list value for required parameter " + name);
        }
        return values;
    }

    public Integer getIntParameter(String name, Integer defaultValue) {
        String value = this.getParameter(name, null);
        if (value == null) {
            return defaultValue;
        }
        return Integer.valueOf(value);
    }

    public Double getFloatParameter(String name, Double defaultValue) {
        String value = this.getParameter(name, null);
        if (value == null) {
            return defaultValue;
        }
        return Double.valueOf(value);
    }

    public Boolean getBooleanParameter(String name, Boolean defaultValue) {
        String value = this.getParameter(name, null);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.valueOf(value);
    }

    public Integer getRequiredIntParameter(String name) throws MissingParameterException {
        String value = this.getRequiredParameter(name);
        return Integer.valueOf(value);
    }

    public Double getRequiredFloatParameter(String name) throws MissingParameterException {
        String value = this.getRequiredParameter(name);
        return Double.valueOf(value);
    }

    public Boolean getRequiredBooleanParameter(String name) throws MissingParameterException {
        String value = this.getRequiredParameter(name);
        return Boolean.valueOf(value);
    }

    public AnyMap getSubParameter(String name) {
        List<AnyMap> parameters = this.getSubParameters(name);
        if (parameters == null || parameters.isEmpty()) {
            return null;
        }
        return parameters.get(0);
    }

    public List<AnyMap> getSubParameters(String name) {
        List<AnyMap> parameters = null;
        if (this._recordId != null) {
            parameters = this.getRecordSubParameters(name, this._recordId);
        }
        if (parameters == null && this._config != null) {
            parameters = this.getSubParametersFromMap(name, this._config);
        }
        if (parameters == null) {
            return Collections.EMPTY_LIST;
        }
        return parameters;
    }

    public Any getParameterAny(String name) {
        AnyMap recordParameters;
        if (this._recordId != null && (recordParameters = this.getRecordParameterMap()) != null && recordParameters.containsKey((Object)name)) {
            return (Any)recordParameters.get((Object)name);
        }
        if (this._config != null) {
            return (Any)this._config.get((Object)name);
        }
        return null;
    }

    private String getRecordParameter(String name, String record) {
        String parameterValue = null;
        AnyMap parameters = this.getRecordParameterMap();
        if (parameters != null) {
            parameterValue = this.getParameterFromMap(name, parameters);
        }
        return parameterValue;
    }

    private String getParameterFromMap(String name, AnyMap map) {
        block4: {
            try {
                Any attribute = (Any)map.get((Object)name);
                if (attribute == null || attribute.isMap()) break block4;
                if (attribute.isSeq()) {
                    if (!((AnySeq)attribute).isEmpty()) {
                        return ((AnySeq)attribute).getStringValue(0);
                    }
                    break block4;
                }
                return ((Value)attribute).asString();
            }
            catch (InvalidValueTypeException invalidValueTypeException) {}
        }
        return null;
    }

    private List<String> getRecordParameters(String name, String record) {
        List<String> parameterValue = null;
        AnyMap parameters = this.getRecordParameterMap();
        if (parameters != null && parameters.isMap()) {
            parameterValue = this.getParametersFromMap(name, parameters);
        }
        return parameterValue;
    }

    private List<String> getParametersFromMap(String name, AnyMap map) {
        Any attribute = (Any)map.get((Object)name);
        if (attribute != null && !attribute.isMap()) {
            ArrayList<String> values = new ArrayList<String>();
            if (attribute.isSeq()) {
                for (Any value : (AnySeq)attribute) {
                    if (!value.isValue()) continue;
                    values.add(((Value)value).asString());
                }
            } else {
                values.add(((Value)attribute).asString());
            }
            return values;
        }
        return null;
    }

    private List<AnyMap> getRecordSubParameters(String name, String record) {
        List<AnyMap> parameterValue = null;
        AnyMap parameters = this.getRecordParameterMap();
        if (parameters != null && parameters.isMap()) {
            parameterValue = this.getSubParametersFromMap(name, parameters);
        }
        return parameterValue;
    }

    private List<AnyMap> getSubParametersFromMap(String name, AnyMap map) {
        Any annotation = (Any)map.get((Object)name);
        if (annotation != null) {
            ArrayList<AnyMap> subMaps = new ArrayList<AnyMap>();
            if (annotation.isMap()) {
                subMaps.add((AnyMap)annotation);
            } else if (annotation.isSeq()) {
                for (Any element : (AnySeq)annotation) {
                    if (!element.isMap()) continue;
                    subMaps.add((AnyMap)element);
                }
            }
            return subMaps;
        }
        return null;
    }

    private AnyMap getRecordParameterMap() {
        if (this._blackboard != null && this._recordId != null) {
            try {
                Any parameters;
                AnyMap recordData = this._blackboard.getMetadata(this._recordId);
                if (this._parametersAttribute == null) {
                    return recordData;
                }
                if (recordData != null && (parameters = (Any)recordData.get((Object)this._parametersAttribute)) != null && parameters.isMap()) {
                    return (AnyMap)parameters;
                }
            }
            catch (BlackboardAccessException blackboardAccessException) {}
        }
        return null;
    }
}

