/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.db;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.derby.iapi.error.PublicAPI;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.conn.Authorizer;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.TransactionController;

public final class PropertyInfo {
    public static Properties getTableProperties(String schemaName, String tableName) throws SQLException {
        return PropertyInfo.getConglomerateProperties(schemaName, tableName, false);
    }

    public static Properties getIndexProperties(String schemaName, String indexName) throws SQLException {
        return PropertyInfo.getConglomerateProperties(schemaName, indexName, true);
    }

    public static void setDatabaseProperty(String key, String value) throws SQLException {
        LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
        try {
            Authorizer a = lcc.getAuthorizer();
            a.authorize(null, 5);
            TransactionController tc = lcc.getTransactionExecute();
            tc.setProperty(key, (Serializable)((Object)value), false);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    private PropertyInfo() {
    }

    private static Properties getConglomerateProperties(String schemaName, String conglomerateName, boolean isIndex) throws SQLException {
        LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
        TransactionController tc = lcc.getTransactionExecute();
        try {
            long conglomerateNumber;
            DataDictionary dd = lcc.getDataDictionary();
            SchemaDescriptor sd = dd.getSchemaDescriptor(schemaName, tc, true);
            if (!isIndex) {
                TableDescriptor td = dd.getTableDescriptor(conglomerateName, sd, tc);
                if (td == null || td.getTableType() == 2) {
                    return new Properties();
                }
                conglomerateNumber = td.getHeapConglomerateId();
            } else {
                ConglomerateDescriptor cd = dd.getConglomerateDescriptor(conglomerateName, sd, false);
                if (cd == null) {
                    return new Properties();
                }
                conglomerateNumber = cd.getConglomerateNumber();
            }
            ConglomerateController cc = tc.openConglomerate(conglomerateNumber, false, 0, 6, 5);
            Properties properties = tc.getUserCreateConglomPropList();
            cc.getTableProperties(properties);
            cc.close();
            return properties;
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }
}

