/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.load;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import org.apache.derby.iapi.error.PublicAPI;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.load.ColumnInfo;
import org.apache.derby.impl.load.ControlInfo;
import org.apache.derby.impl.load.ImportAbstract;
import org.apache.derby.impl.load.ImportReadData;
import org.apache.derby.impl.load.LoadError;

public class Import
extends ImportAbstract {
    private static int _importCounter;
    private static Hashtable _importers;
    private String inputFileName;

    public Import(String inputFileName, String columnDelimiter, String characterDelimiter, String codeset, int noOfColumnsExpected, String columnTypes, boolean lobsInExtFile, int importCounter) throws SQLException {
        try {
            this.inputFileName = inputFileName;
            this.noOfColumnsExpected = noOfColumnsExpected;
            this.tableColumnTypesStr = columnTypes;
            this.controlFileReader = new ControlInfo();
            this.controlFileReader.setControlProperties(characterDelimiter, columnDelimiter, codeset);
            this.lobsInExtFile = lobsInExtFile;
            _importers.put(new Integer(importCounter), this);
            this.doImport();
        }
        catch (Exception e) {
            throw this.importError(e);
        }
    }

    private void doImport() throws Exception {
        if (this.inputFileName == null) {
            throw LoadError.dataFileNull();
        }
        this.doAllTheWork();
    }

    public static void importTable(Connection connection, String schemaName, String tableName, String inputFileName, String columnDelimiter, String characterDelimiter, String codeset, short replace, boolean lobsInExtFile) throws SQLException {
        Import.performImport(connection, schemaName, null, null, tableName, inputFileName, columnDelimiter, characterDelimiter, codeset, replace, lobsInExtFile);
    }

    public static void importData(Connection connection, String schemaName, String tableName, String insertColumnList, String columnIndexes, String inputFileName, String columnDelimiter, String characterDelimiter, String codeset, short replace, boolean lobsInExtFile) throws SQLException {
        Import.performImport(connection, schemaName, insertColumnList, columnIndexes, tableName, inputFileName, columnDelimiter, characterDelimiter, codeset, replace, lobsInExtFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performImport(Connection connection, String schemaName, String insertColumnList, String columnIndexes, String tableName, String inputFileName, String columnDelimiter, String characterDelimiter, String codeset, short replace, boolean lobsInExtFile) throws SQLException {
        Integer importCounter = new Integer(Import.bumpImportCounter());
        try {
            if (connection == null) {
                throw LoadError.connectionNull();
            }
            if (tableName == null) {
                throw LoadError.entityNameMissing();
            }
            ColumnInfo columnInfo = new ColumnInfo(connection, schemaName, tableName, insertColumnList, columnIndexes, "COLUMN");
            StringBuffer sb = new StringBuffer("new ");
            sb.append("org.apache.derby.impl.load.Import");
            sb.append("(");
            sb.append(Import.quoteStringArgument(inputFileName));
            sb.append(",");
            sb.append(Import.quoteStringArgument(columnDelimiter));
            sb.append(",");
            sb.append(Import.quoteStringArgument(characterDelimiter));
            sb.append(",");
            sb.append(Import.quoteStringArgument(codeset));
            sb.append(", ");
            sb.append(columnInfo.getExpectedNumberOfColumnsInFile());
            sb.append(", ");
            sb.append(Import.quoteStringArgument(columnInfo.getExpectedVtiColumnTypesAsString()));
            sb.append(", ");
            sb.append(lobsInExtFile);
            sb.append(", ");
            sb.append(importCounter);
            sb.append(" )");
            String importvti = sb.toString();
            String entityName = IdUtil.mkQualifiedName(schemaName, tableName);
            String insertModeValue = replace > 0 ? "replace" : "bulkInsert";
            String cNamesWithCasts = columnInfo.getColumnNamesWithCasts();
            String insertColumnNames = columnInfo.getInsertColumnNames();
            insertColumnNames = insertColumnNames != null ? "(" + insertColumnNames + ") " : "";
            String insertSql = "INSERT INTO " + entityName + insertColumnNames + " --DERBY-PROPERTIES insertMode=" + insertModeValue + "\n" + " SELECT " + cNamesWithCasts + " from " + importvti + " AS importvti";
            PreparedStatement ips = connection.prepareStatement(insertSql);
            Statement statement = connection.createStatement();
            String lockSql = "LOCK TABLE " + entityName + " IN EXCLUSIVE MODE";
            statement.executeUpdate(lockSql);
            try {
                ips.executeUpdate();
            }
            catch (Throwable t) {
                throw Import.formatImportError((Import)_importers.get(importCounter), inputFileName, t);
            }
            statement.close();
            ips.close();
        }
        finally {
            _importers.remove(importCounter);
        }
    }

    ImportReadData getImportReadData() throws Exception {
        return new ImportReadData(this.inputFileName, this.controlFileReader);
    }

    private static synchronized int bumpImportCounter() {
        return ++_importCounter;
    }

    private static SQLException formatImportError(Import importer, String inputFile, Throwable t) {
        int lineNumber = -1;
        if (importer != null) {
            lineNumber = importer.getCurrentLineNumber();
        }
        StandardException se = StandardException.newException("XIE0R.S", (Object)new Integer(lineNumber), (Object)inputFile, (Object)t.getMessage());
        se.initCause(t);
        return PublicAPI.wrapStandardException(se);
    }

    private static String quoteStringArgument(String string) {
        if (string == null) {
            return "NULL";
        }
        return StringUtil.quoteStringLiteral(string);
    }

    static {
        _importers = new Hashtable();
    }
}

