/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql;

import java.sql.Timestamp;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.GeneratedClass;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.PreparedStatement;
import org.apache.derby.iapi.sql.Statement;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.Parser;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.impl.sql.CursorInfo;
import org.apache.derby.impl.sql.GenericPreparedStatement;
import org.apache.derby.impl.sql.GenericStorablePreparedStatement;
import org.apache.derby.impl.sql.compile.StatementNode;
import org.apache.derby.impl.sql.conn.GenericLanguageConnectionContext;

public class GenericStatement
implements Statement {
    private final SchemaDescriptor compilationSchema;
    private final String statementText;
    private final boolean isForReadOnly;
    private int prepareIsolationLevel;
    private GenericPreparedStatement preparedStmt;

    public GenericStatement(SchemaDescriptor compilationSchema, String statementText, boolean isForReadOnly) {
        this.compilationSchema = compilationSchema;
        this.statementText = statementText;
        this.isForReadOnly = isForReadOnly;
    }

    public PreparedStatement prepare(LanguageConnectionContext lcc) throws StandardException {
        return this.prepMinion(lcc, true, null, null, false);
    }

    public PreparedStatement prepare(LanguageConnectionContext lcc, boolean forMetaData) throws StandardException {
        return this.prepMinion(lcc, true, null, null, forMetaData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement prepMinion(LanguageConnectionContext lcc, boolean cacheMe, Object[] paramDefaults, SchemaDescriptor spsSchema, boolean internalSQL) throws StandardException {
        long beginTime = 0L;
        long parseTime = 0L;
        long bindTime = 0L;
        long optimizeTime = 0L;
        long generateTime = 0L;
        Timestamp beginTimestamp = null;
        Timestamp endTimestamp = null;
        StatementContext statementContext = null;
        if (this.preparedStmt != null && this.preparedStmt.upToDate()) {
            return this.preparedStmt;
        }
        if (lcc.getOptimizerTrace()) {
            lcc.setOptimizerTraceOutput(this.getSource() + "\n");
        }
        if ((beginTime = GenericStatement.getCurrentTimeMillis(lcc)) != 0L) {
            beginTimestamp = new Timestamp(beginTime);
        }
        this.prepareIsolationLevel = lcc.getPrepareIsolationLevel();
        boolean foundInCache = false;
        if (this.preparedStmt == null) {
            if (cacheMe) {
                this.preparedStmt = (GenericPreparedStatement)((GenericLanguageConnectionContext)lcc).lookupStatement(this);
            }
            if (this.preparedStmt == null) {
                this.preparedStmt = new GenericPreparedStatement(this);
            } else {
                foundInCache = true;
            }
        }
        GenericPreparedStatement genericPreparedStatement = this.preparedStmt;
        synchronized (genericPreparedStatement) {
            while (true) {
                if (foundInCache && this.preparedStmt.referencesSessionSchema()) {
                    foundInCache = false;
                    this.preparedStmt = new GenericPreparedStatement(this);
                    break;
                }
                if (this.preparedStmt.upToDate()) {
                    return this.preparedStmt;
                }
                if (!this.preparedStmt.compilingStatement) break;
                try {
                    this.preparedStmt.wait();
                }
                catch (InterruptedException ie) {
                    throw StandardException.interrupt(ie);
                }
            }
            this.preparedStmt.compilingStatement = true;
            this.preparedStmt.setActivationClass(null);
        }
        try {
            Object istream;
            Object object = istream = lcc.getLogStatementText() ? Monitor.getStream() : null;
            if (!this.preparedStmt.isStorable() || lcc.getStatementDepth() == 0) {
                statementContext = lcc.pushStatementContext(true, this.isForReadOnly, this.getSource(), null, false, 0L);
            }
            CompilerContext cc = lcc.pushCompilerContext(this.compilationSchema);
            if (this.prepareIsolationLevel != 0) {
                cc.setScanIsolationLevel(this.prepareIsolationLevel);
            }
            if (internalSQL || spsSchema != null && spsSchema.isSystemSchema() && spsSchema.equals(this.compilationSchema)) {
                cc.setReliability(0);
            }
            try {
                if (istream != null) {
                    String xactId = lcc.getTransactionExecute().getActiveStateTxIdString();
                    istream.printlnWithHeader("(XID = " + xactId + "), " + "(SESSIONID = " + lcc.getInstanceNumber() + "), " + "(DATABASE = " + lcc.getDbname() + "), " + "(DRDAID = " + lcc.getDrdaID() + "), Begin compiling prepared statement: " + this.getSource() + " :End prepared statement");
                }
                Parser p = cc.getParser();
                cc.setCurrentDependent(this.preparedStmt);
                StatementNode qt = p.parseStatement(this.statementText, paramDefaults);
                parseTime = GenericStatement.getCurrentTimeMillis(lcc);
                if (SanityManager.DEBUG_ON("DumpParseTree")) {
                    qt.treePrint();
                }
                if (SanityManager.DEBUG_ON("StopAfterParsing")) {
                    lcc.setLastQueryTree(qt);
                    throw StandardException.newException("42Z55.U");
                }
                DataDictionary dataDictionary = lcc.getDataDictionary();
                int ddMode = dataDictionary == null ? 0 : dataDictionary.startReading(lcc);
                try {
                    lcc.beginNestedTransaction(true);
                    qt.bindStatement();
                    bindTime = GenericStatement.getCurrentTimeMillis(lcc);
                    if (SanityManager.DEBUG_ON("DumpBindTree")) {
                        qt.treePrint();
                    }
                    if (SanityManager.DEBUG_ON("StopAfterBinding")) {
                        throw StandardException.newException("42Z56.U");
                    }
                    if (this.preparedStmt.referencesSessionSchema(qt) && foundInCache) {
                        ((GenericLanguageConnectionContext)lcc).removeStatement(this);
                    }
                    qt.optimizeStatement();
                    optimizeTime = GenericStatement.getCurrentTimeMillis(lcc);
                    if (istream != null) {
                        String xactId = lcc.getTransactionExecute().getActiveStateTxIdString();
                        istream.printlnWithHeader("(XID = " + xactId + "), " + "(SESSIONID = " + lcc.getInstanceNumber() + "), " + "(DATABASE = " + lcc.getDbname() + "), " + "(DRDAID = " + lcc.getDrdaID() + "), End compiling prepared statement: " + this.getSource() + " :End prepared statement");
                    }
                }
                catch (StandardException se) {
                    lcc.commitNestedTransaction();
                    if (istream != null) {
                        String xactId = lcc.getTransactionExecute().getActiveStateTxIdString();
                        istream.printlnWithHeader("(XID = " + xactId + "), " + "(SESSIONID = " + lcc.getInstanceNumber() + "), " + "(DATABASE = " + lcc.getDbname() + "), " + "(DRDAID = " + lcc.getDrdaID() + "), Error compiling prepared statement: " + this.getSource() + " :End prepared statement");
                    }
                    throw se;
                }
                finally {
                    if (dataDictionary != null) {
                        dataDictionary.doneReading(ddMode, lcc);
                    }
                }
                try {
                    if (SanityManager.DEBUG_ON("DumpOptimizedTree")) {
                        qt.treePrint();
                    }
                    if (SanityManager.DEBUG_ON("StopAfterOptimizing")) {
                        throw StandardException.newException("42Z57.U");
                    }
                    GeneratedClass ac = qt.generate(this.preparedStmt.getByteCodeSaver());
                    generateTime = GenericStatement.getCurrentTimeMillis(lcc);
                    if (generateTime != 0L) {
                        endTimestamp = new Timestamp(generateTime);
                    }
                    if (SanityManager.DEBUG_ON("StopAfterGenerating")) {
                        throw StandardException.newException("42Z58.U");
                    }
                    this.preparedStmt.setConstantAction(qt.makeConstantAction());
                    this.preparedStmt.setSavedObjects(cc.getSavedObjects());
                    this.preparedStmt.setRequiredPermissionsList(cc.getRequiredPermissionsList());
                    this.preparedStmt.setActivationClass(ac);
                    this.preparedStmt.setNeedsSavepoint(qt.needsSavepoint());
                    this.preparedStmt.setCursorInfo((CursorInfo)cc.getCursorInfo());
                    this.preparedStmt.setIsAtomic(qt.isAtomic());
                    this.preparedStmt.setExecuteStatementNameAndSchema(qt.executeStatementName(), qt.executeSchemaName());
                    this.preparedStmt.setSPSName(qt.getSPSName());
                    this.preparedStmt.completeCompile(qt);
                    this.preparedStmt.setCompileTimeWarnings(cc.getWarnings());
                }
                catch (StandardException e) {
                    lcc.commitNestedTransaction();
                    throw e;
                }
                if (lcc.getRunTimeStatisticsMode()) {
                    this.preparedStmt.setCompileTimeMillis(parseTime - beginTime, bindTime - parseTime, optimizeTime - bindTime, generateTime - optimizeTime, GenericStatement.getElapsedTimeMillis(beginTime), beginTimestamp, endTimestamp);
                }
            }
            finally {
                lcc.popCompilerContext(cc);
            }
        }
        catch (StandardException se) {
            if (foundInCache) {
                ((GenericLanguageConnectionContext)lcc).removeStatement(this);
            }
            throw se;
        }
        finally {
            GenericPreparedStatement genericPreparedStatement2 = this.preparedStmt;
            synchronized (genericPreparedStatement2) {
                this.preparedStmt.compilingStatement = false;
                this.preparedStmt.notifyAll();
            }
        }
        lcc.commitNestedTransaction();
        if (statementContext != null) {
            lcc.popStatementContext(statementContext, null);
        }
        return this.preparedStmt;
    }

    public PreparedStatement prepareStorable(LanguageConnectionContext lcc, PreparedStatement ps, Object[] paramDefaults, SchemaDescriptor spsSchema, boolean internalSQL) throws StandardException {
        if (ps == null) {
            ps = new GenericStorablePreparedStatement(this);
        } else {
            ((GenericPreparedStatement)ps).statement = this;
        }
        this.preparedStmt = (GenericPreparedStatement)ps;
        return this.prepMinion(lcc, false, paramDefaults, spsSchema, internalSQL);
    }

    public String getSource() {
        return this.statementText;
    }

    public String getCompilationSchema() {
        return this.compilationSchema.getDescriptorName();
    }

    private static long getCurrentTimeMillis(LanguageConnectionContext lcc) {
        if (lcc.getStatisticsTiming()) {
            return System.currentTimeMillis();
        }
        return 0L;
    }

    private static long getElapsedTimeMillis(long beginTime) {
        if (beginTime != 0L) {
            return System.currentTimeMillis() - beginTime;
        }
        return 0L;
    }

    public PreparedStatement getPreparedStatement() {
        return this.preparedStmt;
    }

    public boolean equals(Object other) {
        if (other instanceof GenericStatement) {
            GenericStatement os = (GenericStatement)other;
            return this.statementText.equals(os.statementText) && this.isForReadOnly == os.isForReadOnly && this.compilationSchema.equals(os.compilationSchema) && this.prepareIsolationLevel == os.prepareIsolationLevel;
        }
        return false;
    }

    public int hashCode() {
        return this.statementText.hashCode();
    }
}

