/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.wsdl.Operation;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.common.ProcessState;
import org.apache.ode.bpel.dao.CorrelationSetDAO;
import org.apache.ode.bpel.dao.CorrelatorDAO;
import org.apache.ode.bpel.dao.MessageDAO;
import org.apache.ode.bpel.dao.MessageExchangeDAO;
import org.apache.ode.bpel.dao.PartnerLinkDAO;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.dao.ScopeDAO;
import org.apache.ode.bpel.dao.XmlDataDAO;
import org.apache.ode.bpel.engine.BpelInstanceWorker;
import org.apache.ode.bpel.engine.Contexts;
import org.apache.ode.bpel.engine.ODEProcess;
import org.apache.ode.bpel.engine.WorkEvent;
import org.apache.ode.bpel.evar.ExternalVariableModule;
import org.apache.ode.bpel.evar.ExternalVariableModuleException;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.evt.CorrelationSetWriteEvent;
import org.apache.ode.bpel.evt.ProcessCompletionEvent;
import org.apache.ode.bpel.evt.ProcessInstanceEvent;
import org.apache.ode.bpel.evt.ProcessInstanceStateChangeEvent;
import org.apache.ode.bpel.evt.ProcessMessageExchangeEvent;
import org.apache.ode.bpel.evt.ProcessTerminationEvent;
import org.apache.ode.bpel.evt.ScopeEvent;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.iapi.ContextException;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.PartnerRoleChannel;
import org.apache.ode.bpel.memdao.ProcessInstanceDaoImpl;
import org.apache.ode.bpel.rapi.CorrelationSet;
import org.apache.ode.bpel.rapi.FaultInfo;
import org.apache.ode.bpel.rapi.NoSuchOperationException;
import org.apache.ode.bpel.rapi.OdeRTInstance;
import org.apache.ode.bpel.rapi.OdeRTInstanceContext;
import org.apache.ode.bpel.rapi.PartnerLink;
import org.apache.ode.bpel.rapi.PartnerLinkModel;
import org.apache.ode.bpel.rapi.Selector;
import org.apache.ode.bpel.rapi.UninitializedPartnerEPR;
import org.apache.ode.bpel.rapi.UninitializedVariableException;
import org.apache.ode.bpel.rapi.Variable;
import org.apache.ode.bpel.rapi.VariableContext;
import org.apache.ode.il.config.OdeConfigProperties;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.GUID;
import org.apache.ode.utils.ObjectPrinter;
import org.apache.ode.utils.QNameUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BpelRuntimeContextImpl
implements OdeRTInstanceContext {
    private static final Log __log = LogFactory.getLog(BpelRuntimeContextImpl.class);
    private ProcessInstanceDAO _dao;
    private final Long _iid;
    private MessageExchangeDAO _instantiatingMessageExchange;
    private BpelInstanceWorker _instanceWorker;
    private ODEProcess _bpelProcess;
    private Contexts _contexts;
    private boolean _forceFlush;
    private boolean _forceRollback;
    private int _retryCount;
    private boolean _atomicScope;
    final OdeRTInstance _rti;
    private long _maxReductionTimeMs = 2000000L;

    public BpelRuntimeContextImpl(BpelInstanceWorker bpelInstanceWorker, ProcessInstanceDAO processInstanceDAO, OdeRTInstance odeRTInstance) {
        this._instanceWorker = bpelInstanceWorker;
        this._bpelProcess = bpelInstanceWorker._process;
        this._contexts = bpelInstanceWorker._contexts;
        this._dao = processInstanceDAO;
        this._iid = processInstanceDAO.getInstanceId();
        this._rti = odeRTInstance;
        this._rti.setContext((OdeRTInstanceContext)this);
    }

    public String toString() {
        return "{BpelRuntimeCtx PID=" + this._bpelProcess.getPID() + ", IID=" + this._iid + "}";
    }

    public Long getPid() {
        return this._iid;
    }

    public long genId() {
        return this._dao.genMonotonic();
    }

    public int getRetryCount() {
        return this._retryCount;
    }

    public void setRetryCount(int n) {
        this._retryCount = n;
    }

    public boolean isCorrelationInitialized(CorrelationSet correlationSet) {
        ScopeDAO scopeDAO = this._dao.getScope(Long.valueOf(correlationSet.getScopeId()));
        CorrelationSetDAO correlationSetDAO = scopeDAO.getCorrelationSet(correlationSet.getName());
        return correlationSetDAO.getValue() != null;
    }

    public boolean isVariableInitialized(Variable variable) {
        ScopeDAO scopeDAO = this._dao.getScope(Long.valueOf(variable.getScopeId()));
        XmlDataDAO xmlDataDAO = scopeDAO.getVariable(variable.getName());
        return !xmlDataDAO.isNull();
    }

    public Node initializeVariable(Variable variable, Node node) {
        ScopeDAO scopeDAO = this._dao.getScope(Long.valueOf(variable.getScopeId()));
        XmlDataDAO xmlDataDAO = scopeDAO.getVariable(variable.getName());
        xmlDataDAO.set(node);
        return xmlDataDAO.get();
    }

    public boolean isPartnerRoleEndpointInitialized(PartnerLink partnerLink) {
        PartnerLinkDAO partnerLinkDAO = this.fetchPartnerLinkDAO(partnerLink);
        return partnerLinkDAO.getPartnerEPR() != null || this._bpelProcess.getInitialPartnerRoleEPR(partnerLink.getModel()) != null;
    }

    public void completedFault(FaultInfo faultInfo) {
        if (ODEProcess.__log.isDebugEnabled()) {
            ODEProcess.__log.debug((Object)("ProcessImpl completed with fault '" + faultInfo.getFaultName() + "'"));
        }
        this._dao.setFault(faultInfo.getFaultName(), faultInfo.getExplanation(), faultInfo.getFaultLineNo(), faultInfo.getActivityId(), faultInfo.getFaultMessage());
        ProcessInstanceStateChangeEvent processInstanceStateChangeEvent = new ProcessInstanceStateChangeEvent();
        processInstanceStateChangeEvent.setOldState(this._dao.getState());
        this._dao.setState((short)40);
        processInstanceStateChangeEvent.setNewState((short)40);
        this.sendEvent((ProcessInstanceEvent)processInstanceStateChangeEvent);
        this.sendEvent((ProcessInstanceEvent)new ProcessCompletionEvent(faultInfo.getFaultName()));
        this._dao.finishCompletion();
    }

    public void completedOk() {
        if (ODEProcess.__log.isDebugEnabled()) {
            ODEProcess.__log.debug((Object)("ProcessImpl " + this._bpelProcess.getPID() + " completed OK."));
        }
        ProcessInstanceStateChangeEvent processInstanceStateChangeEvent = new ProcessInstanceStateChangeEvent();
        processInstanceStateChangeEvent.setOldState(this._dao.getState());
        this._dao.setState((short)30);
        processInstanceStateChangeEvent.setNewState((short)30);
        this.sendEvent((ProcessInstanceEvent)processInstanceStateChangeEvent);
        this.sendEvent((ProcessInstanceEvent)new ProcessCompletionEvent(null));
        this._dao.finishCompletion();
    }

    public Long createScopeInstance(Long l, String string, int n) {
        if (ODEProcess.__log.isTraceEnabled()) {
            ODEProcess.__log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"createScopeInstance", (Object[])new Object[]{"parentScopeId", l, "name", string}));
        }
        ScopeDAO scopeDAO = null;
        if (l != null) {
            scopeDAO = this._dao.getScope(l);
        }
        ScopeDAO scopeDAO2 = this._dao.createScope(scopeDAO, string, n);
        return scopeDAO2.getScopeInstanceId();
    }

    public void initializePartnerLinks(Long l, Collection<? extends PartnerLinkModel> collection) {
        if (ODEProcess.__log.isTraceEnabled()) {
            ODEProcess.__log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"initializeEndpointReferences", (Object[])new Object[]{"parentScopeId", l, "partnerLinks", collection}));
        }
        ScopeDAO scopeDAO = this._dao.getScope(l);
        for (PartnerLinkModel partnerLinkModel : collection) {
            PartnerLinkDAO partnerLinkDAO = scopeDAO.createPartnerLink(partnerLinkModel.getId(), partnerLinkModel.getName(), partnerLinkModel.getMyRoleName(), partnerLinkModel.getPartnerRoleName());
            if (!partnerLinkModel.hasMyRole()) continue;
            partnerLinkDAO.setMySessionId(new GUID().toString());
        }
    }

    public void select(String string, Date date, Selector[] selectorArray) {
        Object object;
        if (ODEProcess.__log.isTraceEnabled()) {
            ODEProcess.__log.trace((Object)ObjectPrinter.stringifyMethodEnter((String)"select", (Object[])new Object[]{"pickResponseChannel", string, "timeout", date, "selectors", selectorArray}));
        }
        ProcessDAO processDAO = this._dao.getProcess();
        if (this._dao.getState() == 0) {
            object = new ProcessInstanceStateChangeEvent();
            object.setOldState((short)0);
            this._dao.setState((short)10);
            object.setNewState((short)10);
            this.sendEvent((ProcessInstanceEvent)object);
        }
        object = new ArrayList(selectorArray.length);
        for (Selector selector : selectorArray) {
            String string2 = ODEProcess.genCorrelatorId(selector.getPartnerLink().getModel(), selector.getOperation());
            if (ODEProcess.__log.isDebugEnabled()) {
                ODEProcess.__log.debug((Object)("SELECT: " + string + ": USING CORRELATOR " + string2));
            }
            object.add(processDAO.getCorrelator(string2));
        }
        if (this._instantiatingMessageExchange != null && this._dao.getState() == 10) {
            if (ODEProcess.__log.isDebugEnabled()) {
                ODEProcess.__log.debug((Object)("SELECT: " + string + ": CHECKING for NEW INSTANCE match"));
            }
            for (int i = 0; i < object.size(); ++i) {
                CorrelatorDAO correlatorDAO = (CorrelatorDAO)object.get(i);
                if (!correlatorDAO.equals(this._dao.getInstantiatingCorrelator())) continue;
                this.injectMyRoleMessageExchange(string, i, this._instantiatingMessageExchange);
                if (ODEProcess.__log.isDebugEnabled()) {
                    ODEProcess.__log.debug((Object)("SELECT: " + string + ": FOUND match for NEW instance mexRef=" + this._instantiatingMessageExchange));
                }
                return;
            }
        }
        if (date != null) {
            this.registerTimer(string, date);
            if (ODEProcess.__log.isDebugEnabled()) {
                ODEProcess.__log.debug((Object)("SELECT: " + string + "REGISTERED TIMEOUT for " + date));
            }
        }
        for (int i = 0; i < selectorArray.length; ++i) {
            CorrelatorDAO correlatorDAO = (CorrelatorDAO)object.get(i);
            Selector selector = selectorArray[i];
            correlatorDAO.addRoute(string, this._dao, i, selector.getCorrelationKey());
            this.scheduleCorrelatorMatcher(correlatorDAO.getCorrelatorId(), selector.getCorrelationKey());
            if (!ODEProcess.__log.isDebugEnabled()) continue;
            ODEProcess.__log.debug((Object)("SELECT: " + string + ": ADDED ROUTE " + correlatorDAO.getCorrelatorId() + ": " + selector.getCorrelationKey() + " --> " + this._dao.getInstanceId()));
        }
    }

    public CorrelationKey readCorrelation(CorrelationSet correlationSet) {
        ScopeDAO scopeDAO = this._dao.getScope(Long.valueOf(correlationSet.getScopeId()));
        CorrelationSetDAO correlationSetDAO = scopeDAO.getCorrelationSet(correlationSet.getName());
        return correlationSetDAO.getValue();
    }

    public Element fetchPartnerRoleEndpointReferenceData(PartnerLink partnerLink) {
        EndpointReference endpointReference;
        PartnerLinkDAO partnerLinkDAO = this.fetchPartnerLinkDAO(partnerLink);
        Element element = partnerLinkDAO.getPartnerEPR();
        if (element == null && (endpointReference = this._bpelProcess.getInitialPartnerRoleEPR(partnerLink.getModel())) != null) {
            element = endpointReference.toXML().getDocumentElement();
        }
        return element;
    }

    public Element fetchMyRoleEndpointReferenceData(PartnerLink partnerLink) {
        return this._bpelProcess.getInitialMyRoleEPR(partnerLink.getModel()).toXML().getDocumentElement();
    }

    private PartnerLinkDAO fetchPartnerLinkDAO(PartnerLink partnerLink) {
        ScopeDAO scopeDAO = this._dao.getScope(Long.valueOf(partnerLink.getScopeId()));
        return scopeDAO.getPartnerLink(partnerLink.getModel().getId());
    }

    public String readVariableProperty(Variable variable, QName qName) throws UninitializedVariableException {
        ScopeDAO scopeDAO = this._dao.getScope(Long.valueOf(variable.getScopeId()));
        XmlDataDAO xmlDataDAO = scopeDAO.getVariable(variable.getName());
        if (xmlDataDAO.isNull()) {
            throw new UninitializedVariableException();
        }
        return xmlDataDAO.getProperty(QNameUtils.fromQName((QName)qName));
    }

    public Node fetchVariableData(Variable variable, boolean bl) {
        ScopeDAO scopeDAO = this._dao.getScope(Long.valueOf(variable.getScopeId()));
        XmlDataDAO xmlDataDAO = scopeDAO.getVariable(variable.getName());
        if (xmlDataDAO.isNull()) {
            return null;
        }
        return xmlDataDAO.get();
    }

    public void writeEndpointReference(PartnerLink partnerLink, Element element) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Writing endpoint reference " + partnerLink.getName() + " with value " + DOMUtils.domToString((Node)element)));
        }
        PartnerLinkDAO partnerLinkDAO = this.fetchPartnerLinkDAO(partnerLink);
        partnerLinkDAO.setPartnerEPR(element);
    }

    public String fetchEndpointSessionId(PartnerLink partnerLink, boolean bl) throws FaultException {
        PartnerLinkDAO partnerLinkDAO = this.fetchPartnerLinkDAO(partnerLink);
        return bl ? partnerLinkDAO.getMySessionId() : partnerLinkDAO.getPartnerSessionId();
    }

    public Node convertEndpointReference(Element element, Node node) {
        QName qName = node.getNodeType() == 3 ? new QName("http://www.w3.org/2001/XMLSchema", "string") : new QName(node.getNamespaceURI(), node.getLocalName());
        return this._contexts.eprContext.convertEndpoint(qName, element).toXML();
    }

    public void commitChanges(Variable variable, Node node) {
        ScopeDAO scopeDAO = this._dao.getScope(Long.valueOf(variable.getScopeId()));
        XmlDataDAO xmlDataDAO = scopeDAO.getVariable(variable.getName());
        xmlDataDAO.set(node);
    }

    public void writeVariableProperty(Variable variable, QName qName, String string) throws UninitializedVariableException {
        ScopeDAO scopeDAO = this._dao.getScope(Long.valueOf(variable.getScopeId()));
        XmlDataDAO xmlDataDAO = scopeDAO.getVariable(variable.getName());
        if (xmlDataDAO.isNull()) {
            throw new UninitializedVariableException();
        }
        xmlDataDAO.setProperty(QNameUtils.fromQName((QName)qName), string);
    }

    public void reply(String string, PartnerLink partnerLink, String string2, Element element, QName qName) throws NoSuchOperationException {
        MessageExchange.AckType ackType;
        ProcessMessageExchangeEvent processMessageExchangeEvent = new ProcessMessageExchangeEvent();
        processMessageExchangeEvent.setMexId(string);
        processMessageExchangeEvent.setOperation(string2);
        processMessageExchangeEvent.setPortType(partnerLink.getModel().getMyRolePortType().getQName());
        MessageExchangeDAO messageExchangeDAO = this._dao.getConnection().getMessageExchange(string);
        Operation operation = partnerLink.getModel().getMyRoleOperation(string2);
        if (operation == null || operation.getOutput() == null) {
            throw new NoSuchOperationException();
        }
        MessageDAO messageDAO = messageExchangeDAO.createMessage(operation.getOutput().getMessage().getQName());
        this.buildOutgoingMessage(messageDAO, element);
        messageExchangeDAO.setResponse(messageDAO);
        if (qName != null) {
            ackType = MessageExchange.AckType.FAULT;
            messageExchangeDAO.setFault(qName);
            processMessageExchangeEvent.setAspect((short)2);
        } else {
            ackType = MessageExchange.AckType.RESPONSE;
            processMessageExchangeEvent.setAspect((short)1);
        }
        MessageExchange.Status status = messageExchangeDAO.getStatus();
        messageExchangeDAO.setStatus(MessageExchange.Status.ACK);
        messageExchangeDAO.setAckType(ackType);
        this._bpelProcess.onMyRoleMexAck(messageExchangeDAO, status);
        this.sendEvent((ProcessInstanceEvent)processMessageExchangeEvent);
    }

    public void writeCorrelation(CorrelationSet correlationSet, QName[] qNameArray, CorrelationKey correlationKey) throws FaultException {
        Collection collection;
        ProcessDAO processDAO = this._dao.getProcess();
        if (correlationKey.isUnique() && (collection = processDAO.findInstance(correlationKey, false)).size() != 0) {
            __log.debug((Object)("Not creating a new instance for process " + processDAO.getProcessId() + "; unique correlation constraint would be violated!"));
            throw new FaultException(correlationSet.getOwner().getConstantsModel().getDuplicateInstance());
        }
        collection = this._dao.getScope(Long.valueOf(correlationSet.getScopeId()));
        CorrelationSetDAO correlationSetDAO = collection.getCorrelationSet(correlationSet.getName());
        correlationSetDAO.setValue(qNameArray, correlationKey);
        CorrelationSetWriteEvent correlationSetWriteEvent = new CorrelationSetWriteEvent(correlationSet.getName(), correlationKey);
        correlationSetWriteEvent.setScopeId(Long.valueOf(correlationSet.getScopeId()));
        this.sendEvent((ProcessInstanceEvent)correlationSetWriteEvent);
    }

    public void terminate() {
        ProcessInstanceStateChangeEvent processInstanceStateChangeEvent = new ProcessInstanceStateChangeEvent();
        processInstanceStateChangeEvent.setOldState(this._dao.getState());
        this._dao.setState((short)60);
        processInstanceStateChangeEvent.setNewState((short)60);
        this.sendEvent((ProcessInstanceEvent)processInstanceStateChangeEvent);
        this.sendEvent((ProcessInstanceEvent)new ProcessTerminationEvent());
        this._dao.finishCompletion();
    }

    public void registerTimer(String string, Date date) {
        WorkEvent workEvent = new WorkEvent();
        workEvent.setIID(this._dao.getInstanceId());
        workEvent.setProcessId(this._bpelProcess.getPID());
        workEvent.setChannel(string);
        workEvent.setType(WorkEvent.Type.TIMER);
        this._bpelProcess.scheduleWorkEvent(workEvent, date);
    }

    private void scheduleCorrelatorMatcher(String string, CorrelationKey correlationKey) {
        WorkEvent workEvent = new WorkEvent();
        workEvent.setIID(this._dao.getInstanceId());
        workEvent.setProcessId(this._bpelProcess.getPID());
        workEvent.setType(WorkEvent.Type.MATCHER);
        workEvent.setCorrelatorId(string);
        workEvent.setCorrelationKey(correlationKey);
        this._bpelProcess.scheduleWorkEvent(workEvent, null);
    }

    public String invoke(String string, PartnerLink partnerLink, Operation operation, Element element) throws UninitializedPartnerEPR {
        EndpointReference endpointReference;
        MessageExchangeDAO messageExchangeDAO = this._dao.getConnection().createMessageExchange(new GUID().toString(), 'P');
        messageExchangeDAO.setStatus(MessageExchange.Status.REQ);
        messageExchangeDAO.setOperation(operation.getName());
        messageExchangeDAO.setPortType(partnerLink.getModel().getPartnerRolePortType().getQName());
        messageExchangeDAO.setPartnerLinkModelId(partnerLink.getModel().getId());
        PartnerRoleChannel partnerRoleChannel = this._bpelProcess.getPartnerRoleChannel(partnerLink.getModel());
        PartnerLinkDAO partnerLinkDAO = this.fetchPartnerLinkDAO(partnerLink);
        Element element2 = partnerLinkDAO.getPartnerEPR();
        if (element2 == null) {
            endpointReference = partnerRoleChannel.getInitialEndpointReference();
            if (endpointReference == null) {
                throw new UninitializedPartnerEPR();
            }
        } else {
            endpointReference = this._contexts.eprContext.resolveEndpointReference(element2);
        }
        messageExchangeDAO.setEPR(endpointReference.toXML().getDocumentElement());
        messageExchangeDAO.setPartnerLink(partnerLinkDAO);
        messageExchangeDAO.setProcess(this._dao.getProcess());
        messageExchangeDAO.setInstance(this._dao);
        messageExchangeDAO.setPattern(operation.getOutput() != null ? MessageExchange.MessageExchangePattern.REQUEST_RESPONSE : MessageExchange.MessageExchangePattern.REQUEST_ONLY);
        messageExchangeDAO.setChannel(string);
        MessageDAO messageDAO = messageExchangeDAO.createMessage(operation.getInput().getMessage().getQName());
        messageExchangeDAO.setRequest(messageDAO);
        messageExchangeDAO.setTimeout(30000L);
        messageExchangeDAO.setProperty("org.apache.ode.bpel.myRoleTransacted", Boolean.valueOf(this._atomicScope).toString());
        messageDAO.setType(operation.getInput().getMessage().getQName());
        this.buildOutgoingMessage(messageDAO, element);
        ProcessMessageExchangeEvent processMessageExchangeEvent = new ProcessMessageExchangeEvent();
        processMessageExchangeEvent.setOperation(operation.getName());
        processMessageExchangeEvent.setPortType(partnerLink.getModel().getPartnerRolePortType().getQName());
        processMessageExchangeEvent.setAspect((short)3);
        processMessageExchangeEvent.setMexId(messageExchangeDAO.getMessageExchangeId());
        this.sendEvent((ProcessInstanceEvent)processMessageExchangeEvent);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("INVOKING PARTNER: partnerLink=" + partnerLink + ", op=" + operation.getName() + " channel=" + string + ")"));
        }
        this._bpelProcess.invokePartner(messageExchangeDAO);
        switch (messageExchangeDAO.getStatus()) {
            case ACK: {
                if (messageExchangeDAO.getChannel() == null) break;
                this.injectPartnerResponse(messageExchangeDAO.getMessageExchangeId(), messageExchangeDAO.getChannel());
                break;
            }
            case ASYNC: {
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected MEX status: " + messageExchangeDAO.getStatus()));
            }
        }
        return messageExchangeDAO.getMessageExchangeId();
    }

    private void buildOutgoingMessage(MessageDAO messageDAO, Element element) {
        if (element == null) {
            return;
        }
        Document document = DOMUtils.newDocument();
        Element element2 = document.createElement("header");
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element3 = (Element)nodeList.item(i);
            if (element3.getAttribute("headerPart") == null || element3.getAttribute("headerPart").length() <= 0) continue;
            element2.appendChild(document.importNode(element3, true));
            element.removeChild(element3);
        }
        messageDAO.setData(element);
        messageDAO.setHeader(element2);
    }

    public void executeCreateInstance(MessageExchangeDAO messageExchangeDAO) {
        if (messageExchangeDAO == null) {
            throw new NullPointerException();
        }
        this._instantiatingMessageExchange = messageExchangeDAO;
        this._rti.onCreateInstance(messageExchangeDAO.getMessageExchangeId());
        this.execute();
    }

    void execute() {
        if (!this._contexts.isTransacted()) {
            throw new BpelEngineException("MUST RUN IN TRANSACTION!");
        }
        long l = System.currentTimeMillis() + this._maxReductionTimeMs;
        boolean bl = true;
        while (ProcessState.canExecute((short)this._dao.getState()) && System.currentTimeMillis() < l && bl && !this._forceFlush && !this._forceRollback) {
            bl = this._rti.execute();
        }
        this._dao.setLastActiveTime(new Date());
        if (!ProcessState.isFinished((short)this._dao.getState())) {
            if (this._forceRollback) {
                this.rollbackState();
            } else {
                this.saveState();
            }
            if (ProcessState.canExecute((short)this._dao.getState()) && bl) {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("MaxTime exceeded for instance # " + this._iid));
                }
                try {
                    WorkEvent workEvent = new WorkEvent();
                    workEvent.setIID(this._iid);
                    workEvent.setRetryCount(this._retryCount);
                    workEvent.setProcessId(this._bpelProcess.getPID());
                    workEvent.setType(WorkEvent.Type.RESUME);
                    this._contexts.scheduler.schedulePersistedJob(workEvent.getDetail(), new Date());
                }
                catch (ContextException contextException) {
                    __log.error((Object)"Failed to schedule resume task.", (Throwable)contextException);
                    throw new BpelEngineException((Throwable)contextException);
                }
            }
        }
    }

    private void saveState() {
        Object object;
        if (this._bpelProcess.isInMemory()) {
            try {
                ((ProcessInstanceDaoImpl)this._dao).setSoup(this._rti.saveState(null));
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            object = this._rti.saveState((OutputStream)byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        int n = this._dao.getExecutionStateCounter() + 1;
        this._dao.setExecutionStateCounter(n);
        this._dao.setExecutionState(byteArrayOutputStream.toByteArray());
        this._instanceWorker.setCachedState(n, object);
        __log.debug((Object)("CACHE SAVE: #" + n + " for instance " + this._dao.getInstanceId()));
    }

    private void rollbackState() {
        this._contexts.setRollbackOnly();
        int n = this._dao.getExecutionStateCounter();
        this._dao.setExecutionStateCounter(n);
        this._instanceWorker.setCachedState(n, null);
        __log.debug((Object)("CACHE SAVE: #" + n + " for instance " + this._dao.getInstanceId()));
    }

    void injectMyRoleMessageExchange(String string, int n, MessageExchangeDAO messageExchangeDAO) {
        if (this._dao.getState() == 10) {
            if (ODEProcess.__log.isDebugEnabled()) {
                ODEProcess.__log.debug((Object)"INPUTMSGMATCH: Changing process instance state from ready to active");
            }
            this._dao.setState((short)20);
            ProcessInstanceStateChangeEvent processInstanceStateChangeEvent = new ProcessInstanceStateChangeEvent();
            processInstanceStateChangeEvent.setOldState((short)10);
            processInstanceStateChangeEvent.setNewState((short)20);
            this.sendEvent((ProcessInstanceEvent)processInstanceStateChangeEvent);
        }
        this._rti.onSelectEvent(string, messageExchangeDAO.getMessageExchangeId(), n);
    }

    boolean injectTimerEvent(String string) {
        this._dao.getProcess().removeRoutes(string, this._dao);
        if (ProcessState.isFinished((short)this._dao.getState())) {
            return false;
        }
        this._rti.onTimerEvent(string);
        return true;
    }

    public boolean cancelTimer(String string) {
        return true;
    }

    public void cancelSelect(String string) {
        this._dao.getProcess().removeRoutes(string, this._dao);
    }

    void injectPartnerResponse(String string, String string2) {
        OdeRTInstance.InvokeResponseType invokeResponseType;
        if (string2 == null) {
            throw new NullPointerException("Null responseChannelId");
        }
        if (string == null) {
            throw new NullPointerException("Null mexId");
        }
        if (ODEProcess.__log.isDebugEnabled()) {
            __log.debug((Object)("<invoke> response for mexid " + string + " and channel " + string2));
        }
        MessageExchangeDAO messageExchangeDAO = this._dao.getConnection().getMessageExchange(string);
        ProcessMessageExchangeEvent processMessageExchangeEvent = new ProcessMessageExchangeEvent();
        processMessageExchangeEvent.setPortType(messageExchangeDAO.getPortType());
        processMessageExchangeEvent.setMexId(string);
        processMessageExchangeEvent.setOperation(messageExchangeDAO.getOperation());
        MessageExchange.Status status = messageExchangeDAO.getStatus();
        switch (messageExchangeDAO.getAckType()) {
            case FAULT: {
                invokeResponseType = OdeRTInstance.InvokeResponseType.FAULT;
                processMessageExchangeEvent.setAspect((short)5);
                break;
            }
            case RESPONSE: {
                invokeResponseType = OdeRTInstance.InvokeResponseType.REPLY;
                processMessageExchangeEvent.setAspect((short)4);
                break;
            }
            case FAILURE: {
                invokeResponseType = OdeRTInstance.InvokeResponseType.FAILURE;
                processMessageExchangeEvent.setAspect((short)6);
                break;
            }
            default: {
                String string3 = "Invalid response state for mex " + string + ": " + status;
                __log.error((Object)string3);
                return;
            }
        }
        this.sendEvent((ProcessInstanceEvent)processMessageExchangeEvent);
        this._rti.onInvokeResponse(string2, invokeResponseType, string);
    }

    public void sendEvent(ProcessInstanceEvent processInstanceEvent) {
        processInstanceEvent.setProcessId(this._dao.getProcess().getProcessId());
        processInstanceEvent.setProcessName(this._dao.getProcess().getType());
        processInstanceEvent.setProcessInstanceId(this._dao.getInstanceId());
        this._bpelProcess._debugger.onEvent((BpelEvent)processInstanceEvent);
        List list = null;
        if (processInstanceEvent instanceof ScopeEvent) {
            list = ((ScopeEvent)processInstanceEvent).getParentScopesNames();
        }
        this._bpelProcess.saveEvent(processInstanceEvent, this._dao, list);
    }

    public void noreply(String string, FaultInfo faultInfo) {
        MessageExchangeDAO messageExchangeDAO = this._dao.getConnection().getMessageExchange(string);
        if (messageExchangeDAO != null) {
            MessageExchange.Status status = messageExchangeDAO.getStatus();
            if (messageExchangeDAO.getPattern() == MessageExchange.MessageExchangePattern.REQUEST_ONLY) {
                messageExchangeDAO.setAckType(MessageExchange.AckType.ONEWAY);
                messageExchangeDAO.setStatus(MessageExchange.Status.COMPLETED);
                return;
            }
            messageExchangeDAO.setAckType(MessageExchange.AckType.FAILURE);
            messageExchangeDAO.setFailureType(MessageExchange.FailureType.NO_RESPONSE);
            if (faultInfo != null) {
                messageExchangeDAO.setFaultExplanation(faultInfo.toString());
            }
            messageExchangeDAO.setFaultExplanation("Process did not respond.");
            messageExchangeDAO.setStatus(MessageExchange.Status.ACK);
            this._bpelProcess.onMyRoleMexAck(messageExchangeDAO, status);
        }
    }

    public Element getPartnerResponse(String string) {
        return this.mergeHeaders(this._getPartnerResponse(string));
    }

    public Element getMyRequest(String string) {
        MessageExchangeDAO messageExchangeDAO = this._dao.getConnection().getMessageExchange(string);
        if (messageExchangeDAO == null) {
            String string2 = "Engine requested non-existent message exchange: " + string;
            __log.fatal((Object)string2);
            throw new BpelEngineException(string2);
        }
        if (messageExchangeDAO.getDirection() != 'M') {
            String string3 = "Engine requested my-role request for a partner-role mex: " + string;
            __log.fatal((Object)string3);
            throw new BpelEngineException(string3);
        }
        MessageDAO messageDAO = messageExchangeDAO.getRequest();
        if (messageDAO == null) {
            String string4 = "Engine requested request for message exchange that did not have one: " + string;
            __log.fatal((Object)string4);
            throw new BpelEngineException(string4);
        }
        return this.mergeHeaders(messageDAO);
    }

    private Element mergeHeaders(MessageDAO messageDAO) {
        Element element = messageDAO.getData();
        if (messageDAO.getHeader() != null) {
            Object object;
            if (element == null) {
                object = DOMUtils.newDocument();
                element = object.createElement("message");
                object.appendChild(element);
            }
            object = messageDAO.getHeader().getChildNodes();
            for (int i = 0; i < object.getLength(); ++i) {
                if (object.item(i).getNodeType() != 1) continue;
                Element element2 = (Element)object.item(i);
                element2.setAttribute("headerPart", "true");
                element.appendChild(element.getOwnerDocument().importNode(element2, true));
            }
        }
        return element;
    }

    public QName getPartnerFault(String string) {
        MessageExchangeDAO messageExchangeDAO = this._dao.getConnection().getMessageExchange(string);
        if (messageExchangeDAO == null) {
            String string2 = "Engine requested non-existent message exchange: " + string;
            __log.fatal((Object)string2);
            throw new BpelEngineException(string2);
        }
        return messageExchangeDAO.getFault();
    }

    public QName getPartnerResponseType(String string) {
        return this._getPartnerResponse(string).getType();
    }

    public String getPartnerFaultExplanation(String string) {
        MessageExchangeDAO messageExchangeDAO = this._dao.getConnection().getMessageExchange(string);
        return messageExchangeDAO != null ? messageExchangeDAO.getFaultExplanation() : null;
    }

    private MessageDAO _getPartnerResponse(String string) {
        MessageDAO messageDAO;
        MessageExchangeDAO messageExchangeDAO = this._dao.getConnection().getMessageExchange(string);
        if (messageExchangeDAO == null) {
            String string2 = "Engine requested non-existent message exchange: " + string;
            __log.fatal((Object)string2);
            throw new BpelEngineException(string2);
        }
        if (messageExchangeDAO.getDirection() != 'P') {
            String string3 = "Engine requested partner response for a my-role mex: " + string;
            __log.fatal((Object)string3);
            throw new BpelEngineException(string3);
        }
        MessageExchange.Status status = messageExchangeDAO.getStatus();
        if (status == MessageExchange.Status.ACK) {
            messageDAO = messageExchangeDAO.getResponse();
            if (messageDAO == null) {
                String string4 = "Engine requested response for message exchange that did not have one: " + string;
                __log.fatal((Object)string4);
                throw new BpelEngineException(string4);
            }
        } else {
            String string5 = "Engine requested response while the message exchange " + string + " was in the state " + status;
            __log.fatal((Object)string5);
            throw new BpelEngineException(string5);
        }
        return messageDAO;
    }

    public void releasePartnerMex(String string) {
        MessageExchangeDAO messageExchangeDAO = this._dao.getConnection().getMessageExchange(string);
        messageExchangeDAO.release();
    }

    public Element getSourceEPR(String string) {
        MessageExchangeDAO messageExchangeDAO = this._dao.getConnection().getMessageExchange(string);
        String string2 = messageExchangeDAO.getProperty("org.apache.ode.bpel.partnerRoleEPR");
        if (string2 == null) {
            return null;
        }
        try {
            return DOMUtils.stringToDOM((String)string2);
        }
        catch (Exception exception) {
            __log.error((Object)("Invalid value for SEP property org.apache.ode.bpel.partnerRoleEPR: " + string2));
            return null;
        }
    }

    public String getSourceSessionId(String string) {
        MessageExchangeDAO messageExchangeDAO = this._dao.getConnection().getMessageExchange(string);
        return messageExchangeDAO.getProperty("org.apache.ode.bpel.partnerRoleSessionId");
    }

    public void registerActivityForRecovery(String string, long l, String string2, Date date, Element element, String[] stringArray, int n) {
        if (string2 == null) {
            string2 = "Unspecified";
        }
        if (date == null) {
            date = new Date();
        }
        __log.info((Object)("ActivityRecovery: Registering activity " + l + ", failure reason: " + string2 + " on channel " + string));
        this._dao.createActivityRecovery(string, (long)((int)l), string2, date, element, stringArray, n);
    }

    public void unregisterActivityForRecovery(String string) {
        this._dao.deleteActivityRecovery(string);
    }

    void recoverActivity(String string, long l, String string2, FaultInfo faultInfo) {
        this._rti.recoverActivity(string, l, string2, faultInfo);
        this.execute();
    }

    public String fetchMySessionId(PartnerLink partnerLink) {
        String string = this.fetchPartnerLinkDAO(partnerLink).getMySessionId();
        assert (string != null) : "Session ID should always be set!";
        return string;
    }

    public String fetchPartnersSessionId(PartnerLink partnerLink) {
        return this.fetchPartnerLinkDAO(partnerLink).getPartnerSessionId();
    }

    public void initializePartnersSessionId(PartnerLink partnerLink, String string) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("initializing partner " + partnerLink + "  sessionId to " + string));
        }
        this.fetchPartnerLinkDAO(partnerLink).setPartnerSessionId(string);
    }

    public void forceFlush() {
        this._forceFlush = true;
    }

    public void forceRollback() {
        this._forceRollback = true;
    }

    public Node readExtVar(Variable variable, Node node) throws ExternalVariableModuleException {
        ExternalVariableModule.Value value = this._bpelProcess.getEVM().read(variable, node, this._iid);
        return value.value;
    }

    public VariableContext.ValueReferencePair writeExtVar(Variable variable, Node node, Node node2) throws ExternalVariableModuleException {
        VariableContext.ValueReferencePair valueReferencePair = new VariableContext.ValueReferencePair();
        ExternalVariableModule.Value value = this._bpelProcess.getEVM().write(variable, node, node2, this._iid);
        valueReferencePair.reference = value.locator.reference;
        valueReferencePair.value = value.value;
        return valueReferencePair;
    }

    public URI getBaseResourceURI() {
        return this._bpelProcess.getBaseResourceURI();
    }

    protected OdeConfigProperties getProperties() {
        return this._bpelProcess.getProperties();
    }

    public int getAtomicScopeRetryDelay() {
        return this.getProperties().getAtomicScopeRetryDelay();
    }

    public boolean isAtomicScopeFirstTry() {
        return this._retryCount == 0;
    }

    public boolean isAtomicScopeRetryable() {
        return this._retryCount < this.getProperties().getAtomicScopeRetryCount();
    }

    public void setAtomicScopeRetriedOnce() {
        ++this._retryCount;
    }

    public void setAtomicScopeRetriesDone() {
        this._retryCount = this.getProperties().getAtomicScopeRetryCount();
    }

    public void setAtomicScope(boolean bl) {
        this._atomicScope = bl;
        this._bpelProcess._server.setTransacted(bl);
    }

    public boolean isAtomicScope() {
        return this._atomicScope;
    }

    public Node getProcessProperty(QName qName) {
        return this._bpelProcess.getProcessProperty(qName);
    }
}

