/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.scripting.internal;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.eclipse.smila.datamodel.Attachment;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.scripting.internal.ObjectWrapperBase;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Wrapper;

public class AttachmentWrapper
extends ObjectWrapperBase {
    protected static final Charset STRING_AS_ATTACHMENT_CHARSET = Charset.forName("UTF-8");
    private final Record _record;

    public AttachmentWrapper(Record record, Scriptable parentScope) {
        super(parentScope);
        this._record = record;
    }

    public Record unwrap() {
        return this._record;
    }

    public String getClassName() {
        return "AttachmentWrapper";
    }

    public Object get(String name, Scriptable start) {
        return this._record.getAttachment(name);
    }

    public Object get(int index, Scriptable start) {
        throw Context.reportRuntimeError((String)"Number keys are not allowed for Attachments.");
    }

    public boolean has(String name, Scriptable start) {
        return this._record.hasAttachment(name);
    }

    public boolean has(int index, Scriptable start) {
        throw Context.reportRuntimeError((String)"Number keys are not allowed for Attachments.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void put(String name, Scriptable start, Object value) {
        if (value instanceof Wrapper) {
            value = ((Wrapper)value).unwrap();
        }
        if (value instanceof byte[]) {
            this._record.setAttachment(name, (byte[])value);
            return;
        }
        if (value instanceof CharSequence) {
            this._record.setAttachment(name, value.toString().getBytes(STRING_AS_ATTACHMENT_CHARSET));
            return;
        }
        if (value instanceof Attachment) {
            Attachment attachment = (Attachment)value;
            if (!name.equals(attachment.getName())) {
                byte[] attachmentValue = attachment.getAsBytes();
                if (attachmentValue == null) throw Context.reportRuntimeError((String)("Cannot copy attachment content from attachment '" + attachment.getName() + "' to new attachment '" + name + "'"));
                this._record.setAttachment(name, attachmentValue);
                return;
            } else {
                this._record.setAttachment(attachment);
            }
            return;
        }
        if (!(value instanceof InputStream)) throw Context.reportRuntimeError((String)("Invalid attachment type " + value.getClass()));
        InputStream attachmentStream = (InputStream)value;
        try {
            try {
                byte[] attachment = IOUtils.toByteArray((InputStream)attachmentStream);
                this._record.setAttachment(name, attachment);
                return;
            }
            catch (IOException ex) {
                throw Context.reportRuntimeError((String)("Error reading InputStream to attachment '" + name + "': " + ex));
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)attachmentStream);
        }
    }

    public void put(int index, Scriptable start, Object value) {
        throw Context.reportRuntimeError((String)"Number keys are not allowed for Attachments.");
    }

    public void delete(String name) {
        this._record.removeAttachment(name);
    }

    public void delete(int index) {
        throw Context.reportRuntimeError((String)"Number keys are not allowed for Attachments.");
    }

    public Object[] getIds() {
        Object[] ids = new String[this._record.attachmentSize()];
        Iterator names = this._record.getAttachmentNames();
        int i = 0;
        while (names.hasNext()) {
            ids[i++] = (String)names.next();
        }
        return ids;
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        if (hint == null || hint == ScriptRuntime.StringClass) {
            return Arrays.toString(this.getIds());
        }
        return super.getDefaultValue(hint);
    }
}

