/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.scripting.internal;

import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.scripting.ScriptExecutor;
import org.eclipse.smila.scripting.ScriptNotFoundException;
import org.eclipse.smila.scripting.ScriptingEngineException;
import org.eclipse.smila.scripting.internal.AnyMapWrapper;
import org.eclipse.smila.scripting.internal.RecordWrapper;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.commonjs.module.ModuleScript;
import org.mozilla.javascript.commonjs.module.ModuleScriptProvider;
import org.mozilla.javascript.commonjs.module.Require;
import org.mozilla.javascript.commonjs.module.RequireBuilder;

public class JavascriptExecutor
implements AutoCloseable,
ScriptExecutor {
    private final ModuleScriptProvider _scriptProvider;
    private final Scriptable _baseScope;
    private Context _context;
    private Scriptable _scriptScope;
    private String _scriptFile;
    private final Log _log = LogFactory.getLog(this.getClass());

    public JavascriptExecutor(ModuleScriptProvider scriptProvider, Scriptable baseScope) {
        this._scriptProvider = scriptProvider;
        this._baseScope = baseScope;
        this.initScriptScope();
    }

    private void initScriptScope() {
        this._context = Context.enter();
        this._scriptScope = this._context.newObject(this._baseScope);
        this._scriptScope.setPrototype(this._baseScope);
        this._scriptScope.setParentScope(null);
        this.initRequire();
        this._scriptScope.put("exports", this._scriptScope, (Object)this._context.newObject(this._scriptScope));
    }

    private void initRequire() {
        RequireBuilder requireBuilder = new RequireBuilder();
        requireBuilder.setModuleScriptProvider(this._scriptProvider);
        Require require = requireBuilder.createRequire(this._context, this._scriptScope);
        require.install(this._scriptScope);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object loadScript(String scriptFile) throws ScriptingEngineException {
        Object object;
        long compileEndTime = 0L;
        long startTime = System.nanoTime();
        this._scriptFile = scriptFile;
        try {
            ModuleScript script = this._scriptProvider.getModuleScript(this._context, scriptFile, null, null, null);
            compileEndTime = System.nanoTime();
            if (script == null) {
                throw new ScriptNotFoundException("JavaScript script '" + this._scriptFile + "' cannot be loaded.");
            }
            object = script.getScript().exec(this._context, this._scriptScope);
        }
        catch (ScriptingEngineException ex) {
            try {
                throw ex;
                catch (Exception ex2) {
                    throw new ScriptingEngineException("Error loading " + this._scriptFile, ex2);
                }
            }
            catch (Throwable throwable) {
                if (this._log.isDebugEnabled()) {
                    double compileTime = (double)(compileEndTime - startTime) / 1000000.0;
                    double execTime = (double)(System.nanoTime() - compileEndTime) / 1000000.0;
                    this._log.debug((Object)String.format(Locale.ENGLISH, "loadScript times (ms):  Compile %.3f, Exec %.3f", compileTime, execTime));
                }
                throw throwable;
            }
        }
        if (this._log.isDebugEnabled()) {
            double compileTime = (double)(compileEndTime - startTime) / 1000000.0;
            double execTime = (double)(System.nanoTime() - compileEndTime) / 1000000.0;
            this._log.debug((Object)String.format(Locale.ENGLISH, "loadScript times (ms):  Compile %.3f, Exec %.3f", compileTime, execTime));
        }
        return object;
    }

    @Override
    public Record call(String scriptFunction, Record record) throws ScriptingEngineException {
        Function function = this.getFunction(scriptFunction);
        try {
            RecordWrapper wrapper = new RecordWrapper(record, this._baseScope);
            Object result = function.call(this._context, this._scriptScope, this._scriptScope, new Object[]{wrapper});
            return this.getResultRecord(result);
        }
        catch (Exception ex) {
            throw new ScriptingEngineException("Error executing function " + scriptFunction + " in " + this._scriptFile, ex);
        }
    }

    @Override
    public AnyMap call(String scriptFunction, AnyMap arguments) throws ScriptingEngineException {
        Function function = this.getFunction(scriptFunction);
        try {
            Record resultAsRecord;
            AnyMapWrapper wrapper = new AnyMapWrapper(arguments, this._baseScope);
            Object result = function.call(this._context, this._scriptScope, this._scriptScope, new Object[]{wrapper});
            if (result != null && (resultAsRecord = this.getResultRecord(result)) != null) {
                return resultAsRecord.getMetadata();
            }
            return null;
        }
        catch (Exception ex) {
            throw new ScriptingEngineException("Error executing function " + scriptFunction + " in " + this._scriptFile, ex);
        }
    }

    @Override
    public void install(ScriptExecutor.Installable plugin) throws ScriptingEngineException {
        plugin.install(this._scriptScope);
    }

    private Function getFunction(String scriptFunction) throws ScriptingEngineException {
        Object function = this._scriptScope.get(scriptFunction, this._scriptScope);
        if (function == null || !(function instanceof Function)) {
            throw new ScriptNotFoundException("Script " + this._scriptFile + " does not define function '" + scriptFunction + "'");
        }
        return (Function)function;
    }

    private Record getResultRecord(Object result) {
        if (result == null || result instanceof Undefined) {
            return null;
        }
        Record[] resultRecords = RecordWrapper.asRecordArray(result);
        switch (resultRecords.length) {
            case 0: {
                return null;
            }
            case 1: {
                return resultRecords[0];
            }
        }
        Record resultRecord = DataFactory.DEFAULT.createRecord();
        AnySeq recordSequence = resultRecord.getMetadata().getSeq("result", true);
        Record[] recordArray = resultRecords;
        int n = resultRecords.length;
        int n2 = 0;
        while (n2 < n) {
            Record resultRecord2 = recordArray[n2];
            recordSequence.add((Object)resultRecord2.getMetadata());
            ++n2;
        }
        return resultRecord;
    }

    @Override
    public void close() {
        try {
            Context.exit();
        }
        catch (Exception ex) {
            this._log.info((Object)("Exception while closing executor for script " + this._scriptFile), (Throwable)ex);
        }
    }
}

