/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.scripting.internal;

import java.net.URI;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.BlackboardFactory;
import org.eclipse.smila.processing.PipeletTracker;
import org.eclipse.smila.scripting.internal.PipeletBuilder;
import org.eclipse.smila.scripting.internal.ServiceAccessor;
import org.eclipse.wst.jsdt.debug.rhino.debugger.RhinoDebugger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.commonjs.module.ModuleScriptProvider;
import org.mozilla.javascript.commonjs.module.provider.ModuleSourceProvider;
import org.mozilla.javascript.commonjs.module.provider.StrongCachingModuleScriptProvider;
import org.mozilla.javascript.commonjs.module.provider.UrlModuleSourceProvider;
import org.mozilla.javascript.tools.shell.Global;
import org.osgi.framework.BundleContext;

public final class RhinoUtils {
    private static final String SCRIPT_LOG_CATEGORY = "org.eclipse.smila.scripting.js";

    private RhinoUtils() {
        throw new UnsupportedOperationException("RhinoUtils must not be instantiated.");
    }

    public static void printEngineInfo(Log log) {
        Context cx = Context.enter();
        try {
            log.info((Object)("Javascript engine is " + cx.getImplementationVersion()));
            log.info((Object)("Language version " + cx.getLanguageVersion()));
            log.info((Object)("Optimization level " + cx.getOptimizationLevel()));
            log.info((Object)("Interpreter locale " + cx.getLocale()));
        }
        finally {
            Context.exit();
        }
    }

    public static void startDebugger(String connectionString) throws Exception {
        RhinoDebugger debugger = new RhinoDebugger(connectionString);
        debugger.start();
        ContextFactory.getGlobal().addListener((ContextFactory.Listener)debugger);
    }

    public static ModuleScriptProvider createScriptProvider(Path scriptDirectory) {
        List<URI> scriptDirsAsURIs = Arrays.asList(scriptDirectory.toUri());
        UrlModuleSourceProvider sourceProvider = new UrlModuleSourceProvider(scriptDirsAsURIs, null, null, null);
        return new StrongCachingModuleScriptProvider((ModuleSourceProvider)sourceProvider);
    }

    public static Scriptable createBaseScope(BundleContext bundleContext, PipeletTracker pipeletTracker, BlackboardFactory blackboardFactory) {
        Context context = Context.enter();
        try {
            ScriptableObject baseScope = context.initStandardObjects(null, true);
            Global global = new Global(context);
            baseScope.setPrototype((Scriptable)global);
            PipeletBuilder pipeletBuilder = new PipeletBuilder(pipeletTracker, blackboardFactory, (Scriptable)baseScope);
            ServiceAccessor serviceAccessor = new ServiceAccessor(bundleContext);
            Log scriptLog = LogFactory.getLog((String)SCRIPT_LOG_CATEGORY);
            LogFactory logFactory = LogFactory.getFactory();
            ScriptableObject.putProperty((Scriptable)baseScope, (String)"pipelets", (Object)Context.javaToJS((Object)pipeletBuilder, (Scriptable)baseScope));
            ScriptableObject.putProperty((Scriptable)baseScope, (String)"services", (Object)Context.javaToJS((Object)serviceAccessor, (Scriptable)baseScope));
            ScriptableObject.putProperty((Scriptable)baseScope, (String)"log", (Object)Context.javaToJS((Object)scriptLog, (Scriptable)baseScope));
            ScriptableObject.putProperty((Scriptable)baseScope, (String)"LogFactory", (Object)Context.javaToJS((Object)logFactory, (Scriptable)baseScope));
            baseScope.sealObject();
            ScriptableObject scriptableObject = baseScope;
            return scriptableObject;
        }
        finally {
            Context.exit();
        }
    }
}

