/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.scripting.worker;

import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.scripting.ScriptExecutor;
import org.eclipse.smila.scripting.ScriptingEngineException;
import org.eclipse.smila.scripting.internal.AnyWrapper;
import org.eclipse.smila.taskworker.TaskContext;
import org.eclipse.smila.taskworker.output.RecordOutput;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public class EmitFunction
extends BaseFunction
implements ScriptExecutor.Installable {
    private static final long serialVersionUID = 1L;
    private final RecordOutput _outputBulk;
    private final TaskContext _taskContext;

    public EmitFunction(RecordOutput outputBulk, TaskContext taskContext) {
        this._outputBulk = outputBulk;
        this._taskContext = taskContext;
    }

    @Override
    public void install(Object installTarget) throws ScriptingEngineException {
        if (!(installTarget instanceof Scriptable)) {
            throw new ScriptingEngineException("Cannot install emit() function in object of type " + installTarget.getClass());
        }
        Scriptable scope = (Scriptable)installTarget;
        ScriptableObject.putProperty((Scriptable)scope, (String)this.getFunctionName(), (Object)this);
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (args == null || args.length != 1) {
            throw ScriptRuntime.throwError((Context)cx, (Scriptable)scope, (String)"emit() needs one argument");
        }
        Object argument = args[0];
        if (argument instanceof Wrapper) {
            argument = ((Wrapper)argument).unwrap();
        }
        try {
            if (argument instanceof Record) {
                this._outputBulk.writeRecord((Record)argument);
            } else {
                Any object = AnyWrapper.unwrapAny(argument);
                if (object != null) {
                    this._outputBulk.writeAny(object);
                }
            }
        }
        catch (Exception ex) {
            throw Context.throwAsScriptRuntimeEx((Throwable)ex);
        }
        return Undefined.instance;
    }

    public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        throw ScriptRuntime.throwError((Context)cx, (Scriptable)scope, (String)"emit() can not be invoked as a constructor");
    }

    public String getFunctionName() {
        return "emit";
    }

    public int getArity() {
        return 1;
    }

    public int getLength() {
        return 1;
    }
}

