/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.utils.codec;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.codec.BinaryDecoder;
import org.apache.commons.codec.BinaryEncoder;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.io.IOUtils;

public final class EncodingTools {
    private EncodingTools() {
    }

    public static String toBase64(String input) throws IOException {
        return EncodingTools.toBase64(input, "UTF-8");
    }

    public static String toBase64(String input, String charset) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream inputStream = IOUtils.toInputStream((String)input, (String)charset);){
            return EncodingTools.toBase64(inputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String toBase64(byte[] bytes) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
            return EncodingTools.toBase64(inputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String toBase64(InputStream in) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Base64InputStream encodedStream = new Base64InputStream(in, true, -1, null);){
            return IOUtils.toString((InputStream)encodedStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String encode(String input, BinaryEncoder encoder) throws EncoderException {
        return EncodingTools.encode(input, encoder, Charset.forName("UTF-8"));
    }

    public static String encode(String input, BinaryEncoder encoder, Charset charset) throws EncoderException {
        return new String(EncodingTools.encode(input.getBytes(charset), encoder), charset);
    }

    public static byte[] encode(byte[] input, BinaryEncoder encoder) throws EncoderException {
        return encoder.encode(input);
    }

    public static String base64toString(String input) throws IOException {
        return EncodingTools.base64toString(input, "UTF-8");
    }

    public static String base64toString(String input, String charset) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream inputStream = EncodingTools.base64toStream(input, charset);){
            return IOUtils.toString((InputStream)inputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] base64toByteArray(String input) throws IOException {
        return EncodingTools.base64toByteArray(input, "UTF-8");
    }

    public static byte[] base64toByteArray(String input, String charset) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream inputStream = EncodingTools.base64toStream(input, charset);){
            return IOUtils.toByteArray((InputStream)inputStream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static InputStream base64toStream(String input) throws IOException {
        return EncodingTools.base64toStream(input, "UTF-8");
    }

    public static InputStream base64toStream(String input, String charset) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream inputStream = IOUtils.toInputStream((String)input, (String)charset);){
            return new Base64InputStream(inputStream, false);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String decode(String input, BinaryDecoder decoder) throws DecoderException {
        return EncodingTools.decode(input, decoder, Charset.forName("UTF-8"));
    }

    public static String decode(String input, BinaryDecoder decoder, Charset charset) throws DecoderException {
        return new String(EncodingTools.decode(input.getBytes(), decoder), charset);
    }

    public static byte[] decode(byte[] input, BinaryDecoder decoder) throws DecoderException {
        return decoder.decode(input);
    }
}

