/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.utils.file;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class EncodingHelper {
    public static final String ENCODING_UTF_32BE = "UTF-32BE";
    public static final String ENCODING_UTF_32LE = "UTF-32LE";
    public static final String ENCODING_UTF_8 = "UTF-8";
    public static final String ENCODING_UTF_16BE = "UTF-16BE";
    public static final String ENCODING_UTF_16LE = "UTF-16LE";
    private static final int NUMBER_3 = 3;
    private static final int NUMBER_4 = 4;
    private static final int NUMBER_9 = 9;
    private static final byte BOM_00 = 0;
    private static final byte BOM_BB = -69;
    private static final byte BOM_BF = -65;
    private static final byte BOM_EF = -17;
    private static final byte BOM_FE = -2;
    private static final byte BOM_FF = -1;
    private static final int MAX_BYTES = 10000;
    private static final Log LOG = LogFactory.getLog(EncodingHelper.class);

    private EncodingHelper() {
    }

    public static String convertToString(byte[] bytes) throws IOException {
        if (bytes == null) {
            return null;
        }
        if (bytes.length == 0) {
            return "";
        }
        String encoding = EncodingHelper.getEncoding(bytes);
        if (EncodingHelper.isSupportedEncoding(encoding)) {
            return IOUtils.toString((InputStream)new ByteArrayInputStream(bytes), (String)encoding);
        }
        try {
            if (LOG.isDebugEnabled()) {
                if (encoding == null) {
                    LOG.debug((Object)"no encoding detected, trying to convert bytes to String using encoding UTF-8");
                } else {
                    LOG.debug((Object)"trying to convert bytes to String using encoding UTF-8");
                }
            }
            return IOUtils.toString((InputStream)new ByteArrayInputStream(bytes), (String)ENCODING_UTF_8);
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"converting bytes to String using encoding UTF-8 failed", (Throwable)e);
                LOG.debug((Object)"trying to convert bytes to String using default platform encoding.");
            }
            return IOUtils.toString((InputStream)new ByteArrayInputStream(bytes));
        }
    }

    public static boolean isSupportedEncoding(String charset) {
        block3: {
            if (charset != null) {
                try {
                    return Charset.isSupported(charset);
                }
                catch (IllegalCharsetNameException illegalCharsetNameException) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug((Object)("detected charset " + charset + " is not supported"));
                }
            }
        }
        return false;
    }

    public static String getEncoding(byte[] bytes) throws IOException {
        String encoding = EncodingHelper.getEncodingFromBOM(bytes);
        if (encoding == null) {
            encoding = EncodingHelper.getEncodingFromContent(bytes);
        }
        return encoding;
    }

    public static String getEncodingFromBOM(byte[] bom) {
        String encoding = null;
        if (bom != null) {
            if (bom.length > 2 && bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
                encoding = ENCODING_UTF_8;
            } else if (bom.length > 1) {
                if (bom[0] == -2 && bom[1] == -1) {
                    encoding = ENCODING_UTF_16BE;
                } else if (bom[0] == -1 && bom[1] == -2) {
                    encoding = ENCODING_UTF_16LE;
                    if (bom.length > 2 && bom[2] == 0 && bom[3] == 0) {
                        encoding = ENCODING_UTF_32LE;
                    }
                } else if (bom.length > 3 && bom[0] == 0 && bom[1] == 0 && bom[2] == -2 && bom[3] == -1) {
                    encoding = ENCODING_UTF_32BE;
                }
            }
        }
        return encoding;
    }

    public static byte[] removeBOM(byte[] originalBytes) {
        String encoding = EncodingHelper.getEncodingFromBOM(originalBytes);
        if (originalBytes != null && originalBytes.length >= 2 && encoding != null) {
            int bomLength = 0;
            if (encoding.equalsIgnoreCase(ENCODING_UTF_32BE)) {
                bomLength = 4;
            } else if (encoding.equalsIgnoreCase(ENCODING_UTF_32LE)) {
                bomLength = 4;
            } else if (encoding.equalsIgnoreCase(ENCODING_UTF_8)) {
                bomLength = 3;
            } else if (encoding.equalsIgnoreCase(ENCODING_UTF_16BE)) {
                bomLength = 2;
            } else if (encoding.equalsIgnoreCase(ENCODING_UTF_16LE)) {
                bomLength = 2;
            }
            if (bomLength >= 2) {
                try {
                    int size = originalBytes.length - bomLength;
                    byte[] modifiedBytes = new byte[size];
                    System.arraycopy(originalBytes, bomLength, modifiedBytes, 0, size);
                    return modifiedBytes;
                }
                catch (Exception exception) {}
            }
        }
        return originalBytes;
    }

    /*
     * Exception decompiling
     */
    public static String getEncodingFromContent(byte[] bytes) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[WHILELOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static boolean isMarkup(byte[] bytes) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 11[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String getEncodingFromXML(String xml) {
        String enoding = ENCODING_UTF_8;
        int end = -1;
        int start = xml.toLowerCase().indexOf("encoding");
        if (start > -1) {
            int start1 = xml.indexOf("\"", start + 9) + 1;
            int start2 = xml.indexOf("'", start + 9) + 1;
            if (start2 > 0 && (start1 > start2 || start1 <= 0)) {
                start = start2;
                end = xml.indexOf("'", start2);
            } else if (start1 > 0) {
                start = start1;
                end = xml.indexOf("\"", start1);
            }
            if (end > -1) {
                enoding = xml.substring(start, end).trim();
            }
        }
        return enoding;
    }

    private static String getEncodingFromHTML(String html) {
        String encoding = null;
        int startMeta = html.toLowerCase().indexOf("<meta");
        while (startMeta > -1) {
            int endMeta = html.toLowerCase().indexOf(">", startMeta);
            if (endMeta > -1) {
                encoding = EncodingHelper.getEncodingFromMetaTag(html.substring(startMeta, endMeta));
                if (encoding != null) {
                    return encoding;
                }
                startMeta = html.toLowerCase().indexOf("<meta", endMeta);
                continue;
            }
            encoding = EncodingHelper.getEncodingFromMetaTag(html.substring(startMeta));
            if (encoding != null) {
                return encoding;
            }
            startMeta = -1;
        }
        return encoding;
    }

    private static String getEncodingFromMetaTag(String metaTag) {
        String encoding = null;
        int start = metaTag.toLowerCase().indexOf("content-type");
        if (start > -1 && (start = metaTag.indexOf("charset")) > -1 && (start = metaTag.indexOf("=", start)) > -1) {
            int end1 = metaTag.indexOf("\"", start);
            int end2 = metaTag.indexOf("'", start);
            if (end2 > -1 && (end1 > end2 || end1 == -1)) {
                encoding = metaTag.substring(start + 1, end2).trim();
            } else if (end1 > -1) {
                encoding = metaTag.substring(start + 1, end1).trim();
            }
        }
        return encoding;
    }
}

