/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.utils.scriptexecution;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.utils.scriptexecution.LogHelper;
import org.eclipse.smila.utils.scriptexecution.ScriptExecutor;

public class WindowsScriptExecutor
implements ScriptExecutor {
    private final Log _log = LogFactory.getLog(WindowsScriptExecutor.class);

    @Override
    public int execute(File file) throws IOException, InterruptedException {
        this._log.debug((Object)("Executing " + file.getAbsolutePath()));
        String fileName = file.getName();
        IOCase ioCase = IOCase.SYSTEM;
        if (!ioCase.checkEndsWith(fileName, ".cmd") && !ioCase.checkEndsWith(fileName, ".bat")) {
            this._log.debug((Object)"It doesn't end with .cmd or .bat");
            File tempFile = this.getTempCmdFile(file.getParentFile());
            try {
                this._log.debug((Object)("Copy " + file.getAbsolutePath() + " to " + tempFile));
                FileUtils.copyFile((File)file, (File)tempFile);
                int n = this.doExecute(tempFile);
                return n;
            }
            finally {
                tempFile.delete();
            }
        }
        return this.doExecute(file);
    }

    private int doExecute(File file) throws IOException, InterruptedException {
        this._log.debug((Object)("Do Execute " + file.getAbsolutePath()));
        ProcessBuilder processBuilder = new ProcessBuilder(file.getAbsolutePath());
        processBuilder.directory(file.getParentFile());
        processBuilder.redirectErrorStream(true);
        Process process = processBuilder.start();
        int resultCode = process.waitFor();
        LogHelper.debug(this._log, process.getInputStream());
        return resultCode;
    }

    private File getTempCmdFile(File folder) {
        String fileName;
        File tempFile = null;
        while ((tempFile = new File(folder, fileName = ".temp-cmd-file-" + this.hashCode() + "-" + System.currentTimeMillis() + ".cmd")).exists()) {
        }
        return tempFile;
    }
}

