/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.taskworker.util;

import java.util.Map;

public final class Counters {
    public static final double NANOS_PER_SEC = 1.0E9;
    public static final String WARN_COUNT = "warnCount";
    public static final String INPUT = "input";
    public static final String OUTPUT = "output";
    public static final String FUNCTION = "function";
    public static final String DURATION = "duration";
    public static final String DURATION_IODATA = "duration.iodata";
    public static final String DURATION_IODATA_OPEN = "duration.iodata.open";
    public static final String DURATION_IODATA_CLOSE = "duration.iodata.close";
    public static final String DURATION_PERFORM = "duration.perform";
    public static final String DURATION_PERFORM_FUNCTION = "duration.perform.function";
    public static final String DURATION_PERFORM_INPUT = "duration.perform.input";
    public static final String DURATION_PERFORM_OUTPUT = "duration.perform.output";
    public static final String DATAOBJECTCOUNT = "dataObjectCount";

    private Counters() {
        throw new IllegalStateException("prevent instance creation");
    }

    public static void addDuration(Map<String, Number> counters, String key, long nanoSeconds) {
        double duration = (double)nanoSeconds / 1.0E9;
        Counters.add(counters, key, duration);
    }

    public static void add(Map<String, Number> counters, String key, long count) {
        if (counters.containsKey(key)) {
            counters.put(key, counters.get(key).longValue() + count);
        } else {
            counters.put(key, count);
        }
    }

    public static void add(Map<String, Number> counters, String key, double count) {
        if (counters.containsKey(key)) {
            counters.put(key, counters.get(key).doubleValue() + count);
        } else {
            counters.put(key, count);
        }
    }

    public static void addAll(Map<String, Number> counters, Map<String, Number> moreCounters) {
        for (Map.Entry<String, Number> entry : moreCounters.entrySet()) {
            String key = entry.getKey();
            Number value = entry.getValue();
            if (value instanceof Double) {
                Counters.add(counters, key, value.doubleValue());
                continue;
            }
            Counters.add(counters, key, value.longValue());
        }
    }

    public static void addAll(Map<String, Number> counters, Map<String, Number> moreCounters, String prefix) {
        for (Map.Entry<String, Number> entry : moreCounters.entrySet()) {
            String key = entry.getKey();
            Number value = entry.getValue();
            if (value instanceof Double) {
                Counters.add(counters, String.valueOf(prefix) + "." + key, value.doubleValue());
                continue;
            }
            Counters.add(counters, String.valueOf(prefix) + "." + key, value.longValue());
        }
    }
}

