/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.common.definitions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.eclipse.smila.common.definitions.AccessAny;
import org.eclipse.smila.common.definitions.DefinitionBase;
import org.eclipse.smila.common.exceptions.InvalidDefinitionException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Value;

public class ParameterDefinition
extends DefinitionBase {
    public static final String TYPENAME_ANY = "any";
    public static final String KEY_TYPE = "type";
    public static final String KEY_OPTIONAL = "optional";
    public static final String KEY_VALUES = "values";
    public static final String KEY_VALUE = "value";
    public static final String KEY_MULTI = "multi";
    public static final String KEY_ENTRIES = "entries";
    public static final String KEY_RANGE = "range";
    public static final String VARIABLE_NAME_EXPRESSION = "<[^>]*>";
    protected static final Collection<String> MAIN_PARAMETER_KEYS = Collections.unmodifiableList(Arrays.asList("name", "type", "optional", "multi", "values", "range"));
    private final Any.ValueType _type;
    private final boolean _isOptional;
    private final boolean _isMulti;
    private List<ParameterDefinition> _entries;
    private List<Value> _values;
    private final String _range;

    public ParameterDefinition(AnyMap definitionAny) throws InvalidDefinitionException {
        super(definitionAny);
        this._type = this.parseType(this._definitionMap);
        this._isOptional = AccessAny.getBoolean(this._definitionMap, KEY_OPTIONAL, false);
        this._isMulti = AccessAny.getBoolean(this._definitionMap, KEY_MULTI, false);
        this.parseEntries();
        this.parseValues();
        this._range = AccessAny.getString(this._definitionMap, KEY_RANGE);
    }

    private void parseEntries() throws InvalidDefinitionException {
        if (this._definitionMap.containsKey((Object)KEY_ENTRIES)) {
            if (this._type != Any.ValueType.MAP) {
                throw new InvalidDefinitionException("Parameter " + this.getName() + " of type " + this.getTypeName() + " cannot specify entries.");
            }
            this._entries = ParameterDefinition.parseParameters(AccessAny.getSeq(this._definitionMap, KEY_ENTRIES));
        }
    }

    private void parseValues() throws InvalidDefinitionException {
        if (this._definitionMap.containsKey((Object)KEY_VALUES)) {
            if (this._type == null || this._type == Any.ValueType.MAP) {
                throw new InvalidDefinitionException("Parameter " + this.getName() + " of type " + this.getTypeName() + " cannot spefify values.");
            }
            AnySeq valueAnys = AccessAny.getSeq(this._definitionMap, KEY_VALUES);
            if (valueAnys.isEmpty()) {
                throw new InvalidDefinitionException("Value list for parameter " + this.getName() + " must not be emtpy.");
            }
            this._values = new ArrayList<Value>();
            for (Any value : valueAnys) {
                if (value.isMap() && (value = (Any)value.asMap().get((Object)KEY_VALUE)) == null) {
                    throw new InvalidDefinitionException("A map element of the values list of parameter " + this.getName() + " does not contain the required " + KEY_VALUE + " key.");
                }
                if (!value.isValue() || value.getValueType() != this._type) {
                    throw new InvalidDefinitionException("Value " + value + " for parameter " + this.getName() + " is not of type " + this.getTypeName() + ", but " + value.getValueType());
                }
                this._values.add(value.asValue());
            }
        }
    }

    @Override
    protected boolean validateName() {
        return false;
    }

    private Any.ValueType parseType(AnyMap definitionAny) throws InvalidDefinitionException {
        if (definitionAny.containsKey((Object)KEY_TYPE)) {
            Any.ValueType type;
            String typeString = AccessAny.getString(definitionAny, KEY_TYPE);
            if (TYPENAME_ANY.equalsIgnoreCase(typeString)) {
                return null;
            }
            try {
                type = Any.ValueType.valueOf((String)typeString.toUpperCase(Locale.ENGLISH));
            }
            catch (Exception ex) {
                throw new InvalidDefinitionException("Invalid parameter type " + typeString + " for parameter " + this.getName(), ex);
            }
            if (type == Any.ValueType.SEQ) {
                throw new InvalidDefinitionException("Type 'seq' for parameter " + this.getName() + " is not a valid parameter type.");
            }
            return type;
        }
        return Any.ValueType.STRING;
    }

    public static AnySeq toAny(List<ParameterDefinition> parameters, boolean includingAdditionalAttributes) {
        AnySeq paramSeq = DataFactory.DEFAULT.createAnySeq();
        for (ParameterDefinition parameter : parameters) {
            paramSeq.add((Object)parameter.toAny(includingAdditionalAttributes));
        }
        return paramSeq;
    }

    @Override
    public AnyMap toAny(boolean includingAdditionalAttributes) {
        AnyMap origParam = super.toAny(true);
        if (includingAdditionalAttributes) {
            return origParam;
        }
        AnyMap newParam = origParam.getFactory().createAnyMap();
        for (String key : MAIN_PARAMETER_KEYS) {
            if (!origParam.containsKey((Object)key)) continue;
            newParam.put(key, (Any)origParam.get((Object)key));
        }
        if (origParam.containsKey((Object)KEY_ENTRIES)) {
            newParam.put(KEY_ENTRIES, (Any)ParameterDefinition.toAny(this._entries, includingAdditionalAttributes));
        }
        return newParam;
    }

    public static List<ParameterDefinition> parseParameters(AnySeq parameterSequence) throws InvalidDefinitionException {
        ArrayList<ParameterDefinition> parameters = new ArrayList<ParameterDefinition>(parameterSequence.size());
        for (Any parameterAny : parameterSequence) {
            if (parameterAny.isMap()) {
                parameters.add(new ParameterDefinition(parameterAny.asMap()));
                continue;
            }
            throw new InvalidDefinitionException("An element of a parameter definition list is not a map, but a " + parameterAny.getValueType());
        }
        return parameters;
    }

    public Any.ValueType getType() {
        return this._type;
    }

    public String getTypeName() {
        if (this._type == null) {
            return TYPENAME_ANY;
        }
        return this._type.name().toLowerCase(Locale.ENGLISH);
    }

    public boolean isOptional() {
        return this._isOptional;
    }

    public boolean isMulti() {
        return this._isMulti;
    }

    public List<Value> getValues() {
        return AccessAny.copyCollection(this._values);
    }

    public List<ParameterDefinition> getEntries() {
        return AccessAny.copyCollection(this._entries);
    }

    public String getRange() {
        return this._range;
    }
}

