/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets.xmlprocessing;

import javax.xml.transform.stream.StreamResult;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.blackboard.BlackboardAccessException;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.parameters.MissingParameterException;
import org.eclipse.smila.processing.parameters.ParameterAccessor;
import org.eclipse.smila.processing.pipelets.ATransformationPipelet;
import org.eclipse.smila.processing.util.ResultCollector;
import org.eclipse.smila.utils.xml.XMLUtils;
import org.eclipse.smila.utils.xml.XMLUtilsException;
import org.w3c.dom.Document;

public abstract class AXmlTransformationPipelet
extends ATransformationPipelet {
    protected Document createDocument(Blackboard blackboard, String id, ParameterAccessor paramAccessor) throws MissingParameterException, BlackboardAccessException, XMLUtilsException {
        Document inputDocument = null;
        if (this.isReadFromAttribute(this.getInputType(paramAccessor))) {
            String value = blackboard.getMetadata(id).getStringValue(this.getInputName(paramAccessor));
            if (value != null) {
                inputDocument = XMLUtils.parse((byte[])value.getBytes(ENCODING_CHARSET), (boolean)false);
            }
        } else {
            byte[] value = blackboard.getAttachmentAsBytes(id, this.getInputName(paramAccessor));
            if (value != null) {
                inputDocument = XMLUtils.parse((byte[])value, (boolean)false);
            }
        }
        return inputDocument;
    }

    protected void storeDocument(Blackboard blackboard, String id, Document doc, ParameterAccessor paramAccessor) throws Exception {
        if (this.isStoreInAttribute(this.getOutputType(paramAccessor))) {
            String domString = XMLUtils.documentToString((Document)doc);
            blackboard.getMetadata(id).put(this.getOutputName(paramAccessor), domString);
        } else {
            byte[] attachment = XMLUtils.documentToBytes((Document)doc);
            blackboard.setAttachment(id, this.getOutputName(paramAccessor), attachment);
        }
    }

    protected void storeDocument(Blackboard blackboard, String id, StreamResult result, ParameterAccessor paramAccessor) throws Exception {
        if (this.isStoreInAttribute(this.getOutputType(paramAccessor))) {
            blackboard.getMetadata(id).put(this.getOutputName(paramAccessor), result.getWriter().toString());
        } else {
            byte[] attachment = result.getWriter().toString().getBytes(ENCODING_CHARSET);
            blackboard.setAttachment(id, this.getOutputName(paramAccessor), attachment);
        }
    }

    public String[] process(Blackboard blackboard, String[] recordIds) throws ProcessingException {
        if (recordIds != null) {
            ParameterAccessor paramAccessor = new ParameterAccessor(blackboard, this._config);
            ResultCollector resultCollector = new ResultCollector(paramAccessor, this._log, false);
            String[] stringArray = recordIds;
            int n = recordIds.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                paramAccessor.setCurrentRecord(id);
                try {
                    this.processRecord(blackboard, paramAccessor, id);
                    resultCollector.addResult(id);
                }
                catch (Exception e) {
                    resultCollector.addFailedResult(id, e);
                }
                ++n2;
            }
            return resultCollector.getResultIds();
        }
        return null;
    }

    protected abstract void processRecord(Blackboard var1, ParameterAccessor var2, String var3) throws Exception;
}

