/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.crawler.file.filter;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smila.importing.crawler.file.filter.FilterConfiguration;
import org.eclipse.smila.importing.util.FilePathNormalizer;

public class FilterEvaluator {
    private FilterConfiguration _filterConfig;

    public Collection<Path> applyFiltersForCrawledFiles(Path fileDir, Collection<Path> files) throws IOException {
        ArrayList<Path> result = new ArrayList<Path>(files);
        if (this._filterConfig != null) {
            String normalizedFileDir = this.normalize(fileDir);
            Iterator it = result.iterator();
            while (it.hasNext()) {
                Path f = (Path)it.next();
                if (!this._filterConfig.getFilePatternMatcher().matches(f.getFileName().toString())) {
                    it.remove();
                    continue;
                }
                if (Files.size(f) > this._filterConfig.getMaxSize()) {
                    it.remove();
                    continue;
                }
                if (!this._filterConfig.getFolderPatternMatcher().isIncluded(normalizedFileDir)) {
                    it.remove();
                    continue;
                }
                if (!Files.isSymbolicLink(f) || this._filterConfig.followSymbolicLinks()) continue;
                it.remove();
            }
        }
        return result;
    }

    public boolean applyFiltersForCrawledFile(Path fileDir, Path file) throws IOException {
        return !this.applyFiltersForCrawledFiles(fileDir, Arrays.asList(file)).isEmpty();
    }

    public Collection<Path> applyFiltersForCrawledFolders(Collection<Path> folders, String rootFolder) throws IOException {
        ArrayList<Path> result = new ArrayList<Path>(folders);
        if (this._filterConfig != null) {
            String normalizedRoot = this.normalize(rootFolder);
            int rootDepth = StringUtils.countMatches((String)normalizedRoot, (String)"/");
            Iterator it = result.iterator();
            while (it.hasNext()) {
                Path dir = (Path)it.next();
                String normalizedPath = this.normalize(dir);
                int depth = StringUtils.countMatches((String)normalizedPath, (String)"/") - rootDepth;
                if ((long)depth > this._filterConfig.getMaxDepth()) {
                    it.remove();
                    continue;
                }
                if (this._filterConfig.getFolderPatternMatcher().isExcluded(normalizedPath)) {
                    it.remove();
                    continue;
                }
                if (!Files.isSymbolicLink(dir) || this._filterConfig.followSymbolicLinks()) continue;
                it.remove();
            }
        }
        return result;
    }

    public boolean applyFiltersForCrawledFolder(Path folder, String rootFolder) throws IOException {
        return !this.applyFiltersForCrawledFolders(Arrays.asList(folder), rootFolder).isEmpty();
    }

    private String normalize(Path input) throws IOException {
        return FilePathNormalizer.getNormalizedPath((Path)input);
    }

    private String normalize(String input) {
        return FilePathNormalizer.getNormalizedPath((String)input);
    }

    public void setFilterConfiguration(FilterConfiguration filterConfig) {
        this._filterConfig = filterConfig;
    }
}

