/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.httphandler;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.common.params.CollectionParams;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.http.server.HttpExchange;
import org.eclipse.smila.http.server.json.JsonRequestHandler;
import org.eclipse.smila.http.server.util.UnsupportedMethodException;
import org.eclipse.smila.solr.SolrOperationService;

public abstract class AAdminHandler
extends JsonRequestHandler {
    private final Log _log = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected SolrOperationService _operationService;

    public Object process(String method, String requestUri, Record inputRecord, HttpExchange exchange) throws Exception {
        Any result = null;
        switch (method) {
            case "GET": {
                result = this.doGet(exchange, requestUri);
                break;
            }
            case "POST": {
                result = this.doPost(exchange, requestUri);
                break;
            }
            default: {
                throw new UnsupportedMethodException("HttpMethod: [GET, POST]");
            }
        }
        return result;
    }

    abstract Any doGet(HttpExchange var1, String var2) throws Exception;

    Any doPost(HttpExchange exchange, String requestUri) throws Exception {
        String action = this.getAction(requestUri);
        Map params = exchange.getParameterMap();
        return this._operationService.processAdminOperation(action, params);
    }

    protected String getStaticUriPart(String requestUri) {
        return (String)this.getDynamicUriParts(requestUri).get(0);
    }

    protected String getAction(String requestUri) {
        List dynamicUriParts = this.getDynamicUriParts(requestUri);
        if (dynamicUriParts.size() <= 1) {
            String message = String.format("Action must be part of the uri. One of [%s]", StringUtils.join((Object[])CollectionParams.CollectionAction.values(), (char)','));
            throw new IllegalArgumentException(message);
        }
        return (String)dynamicUriParts.get(1);
    }

    protected boolean isValidMethod(String method, String requestUri) {
        return "POST".equals(method) || "GET".equals(method);
    }

    protected void bindSolrOperationService(SolrOperationService operationService) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)"Bind SolrOperationService...");
        }
        this._operationService = operationService;
    }

    protected void unbindSolrOperationService(SolrOperationService operationService) {
        if (this._operationService == operationService) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)"Unbind SolrOperationService...");
            }
            this._operationService = null;
        }
    }
}

