/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.httphandler;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.http.server.HttpExchange;
import org.eclipse.smila.http.server.json.JsonHttpUtils;
import org.eclipse.smila.http.server.util.ARequestHandler;
import org.eclipse.smila.solr.SolrServerService;
import org.eclipse.smila.solr.server.ServerUtil;

public class ServerHandler
extends ARequestHandler {
    private final JsonHttpUtils _jsonHttpUtils = new JsonHttpUtils();
    private SolrServerService _serverService;

    public void handle(HttpExchange exchange) throws IOException {
        String requestUri = exchange.getRequestURI();
        Map params = exchange.getParameterMap();
        String index = this.getIndex(requestUri);
        String operation = this.getOperation(requestUri);
        SolrServer server = null;
        AnyMap result = null;
        try {
            try {
                server = this._serverService.getServer(index);
            }
            catch (SolrServerException exception) {
                throw new IllegalArgumentException("can not get solr server for index: " + index, exception);
            }
            boolean waitFlush = BooleanUtils.toBoolean((String)this.getParameter(params, "waitFlush"));
            boolean waitSearcher = BooleanUtils.toBoolean((String)this.getParameter(params, "waitSearcher"));
            switch (operation) {
                case "commit": {
                    boolean softCommit = BooleanUtils.toBoolean((String)this.getParameter(params, "softCommit"));
                    result = ServerUtil.commit(server, waitFlush, waitSearcher, softCommit);
                    break;
                }
                case "optimize": {
                    int maxSegments = NumberUtils.toInt((String)this.getParameter(params, "maxSegments"), (int)1);
                    result = ServerUtil.optimize(server, waitFlush, waitSearcher, maxSegments);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("operation unknown: " + operation);
                }
            }
        }
        catch (Exception exception) {
            this._jsonHttpUtils.writeErrorDetails(exchange, (Throwable)exception);
            return;
        }
        this._jsonHttpUtils.writeResultObject(exchange.getResponseStream(), (Object)result);
        exchange.getResponseStream().flush();
    }

    private String getIndex(String requestUri) {
        try {
            return (String)this.getDynamicUriParts(requestUri).get(0);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("request uri does not contain index");
        }
    }

    private String getOperation(String requestUri) {
        try {
            return (String)this.getDynamicUriParts(requestUri).get(1);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("request uri does not contain operation");
        }
    }

    private String getParameter(Map<String, String[]> params, String name) {
        String[] param = params.get(name);
        if (param != null && param.length < 0) {
            return param[0];
        }
        return null;
    }

    protected void bindSolrServerService(SolrServerService serverService) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)"Bind SolrServerService...");
        }
        this._serverService = serverService;
    }

    protected void unbindSolrServerService(SolrServerService serverService) {
        if (this._serverService == serverService) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)"Unbind SolrServerService...");
            }
            this._serverService = null;
        }
    }
}

