/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.params;

import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.solr.params.SolrParams;

public class UpdateParams
extends SolrParams {
    public static final String UPDATE = "update";
    public static final String ATTACHMENTS = "attachments";
    public static final String COMMIT_WITHIN_MS = "commitWithinMs";
    public static final int COMMIT_WITHIN_MS_DEFAULT = -1;
    public static final String DOCUMENT_BOOST = "documentBoost";
    public static final float DOCUMENT_BOOST_DEFAULT = 1.0f;
    public static final String MAPPING = "mapping";
    public static final String OPERATION = "operation";
    public static final String DELETE_QUERY = "deleteQuery";

    public UpdateParams(AnyMap configuration) {
        super(configuration);
    }

    public UpdateParams(Blackboard blackboard) {
        super(blackboard);
    }

    public UpdateParams(Blackboard blackboard, AnyMap configuration) {
        super(blackboard, configuration);
    }

    public UpdateParams(Blackboard blackboard, AnyMap configuration, String recordId) {
        super(blackboard, configuration, recordId);
    }

    public UpdateParams(Blackboard blackboard, String recordId) {
        super(blackboard, recordId);
    }

    public Boolean getAttachments(boolean defaultIfNull) {
        Boolean val = this.getSolrParamAsBoolean(UPDATE, ATTACHMENTS);
        if (val == null && defaultIfNull) {
            return false;
        }
        return val;
    }

    public String getIndexName() {
        String parameterAttribute = this.getParameterAttribute();
        this.setParameterAttribute(null);
        String index = this.getParameter("indexname", null);
        this.setParameterAttribute(parameterAttribute);
        return index;
    }

    public Integer getCommitWithinMs(boolean defaultIfNull) {
        Integer val = this.getSolrParamAsInteger(UPDATE, COMMIT_WITHIN_MS);
        if (val == null && defaultIfNull) {
            return -1;
        }
        return val;
    }

    public Float getDocumentBoost(boolean defaultIfNull) {
        Float val = this.getSolrParamAsFloat(UPDATE, DOCUMENT_BOOST);
        if (val == null && defaultIfNull) {
            return Float.valueOf(1.0f);
        }
        return val;
    }

    public AnyMap getMapping(boolean defaultIfNull) {
        AnyMap val = this.getSolrParamAsAnyMap(UPDATE, MAPPING);
        if (val == null && defaultIfNull) {
            return DataFactory.DEFAULT.createAnyMap();
        }
        return val;
    }

    public Operation getOperation() {
        String val = this.getSolrParamAsString(UPDATE, OPERATION);
        if (val == null) {
            throw new NullArgumentException(OPERATION);
        }
        try {
            return Operation.get(val);
        }
        catch (Exception exception) {
            String message = String.format("Operation must be one of [%s].", StringUtils.join((Object[])Operation.values(), (String)", "));
            throw new IllegalArgumentException(message, exception);
        }
    }

    public String getDeleteQeuery() {
        return this.getSolrParamAsString(UPDATE, DELETE_QUERY);
    }

    public static enum Operation {
        ADD,
        DELETE_BY_ID,
        DELETE_BY_QUERY,
        NONE;


        public static Operation get(String label) {
            return Operation.valueOf(label.toUpperCase());
        }
    }
}

